<?php

use backend\components\form\AreisUploader;
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;

/**
 * @var yii\web\View $this
 * @var backend\models\Career $model
 * @var yii\widgets\ActiveForm $form
 */

?>

    <div class="box box-info">
        <div class="box-body">
            <?php $form = ActiveForm::begin([
                    'id' => 'Career',
                    'layout' => 'horizontal',
                    'enableClientValidation' => true,
                    'errorSummaryCssClass' => 'error-summary alert alert-error'
                ]
            );
            ?>

            <?= $form->field($model, 'job_title_english')->textInput(['maxlength' => true]) ?>
            <?= $form->field($model, 'detail_english', ["wrapperOptions" => ["class" => "col-md-8"]])->widget(\backend\components\CKEditorWidget::className()) ?>

            <?= $form->field($model, 'job_title_indonesia')->textInput(['maxlength' => true]) ?>
            <?= $form->field($model, 'detail_indonesia', ["wrapperOptions" => ["class" => "col-md-8"]])->widget(\backend\components\CKEditorWidget::className()) ?>
            <?= $form->field($model, 'apply_url')->textInput(['maxlength' => true]) ?>

            <hr/>
            <?php echo $form->errorSummary($model); ?>
            <div class="row">
                <div class="col-md-offset-3 col-md-10">
                    <?= Html::submitButton('<i class="fa fa-save"></i> Simpan', ['class' => 'btn btn-success']); ?>
                    <?= Html::a('<i class="fa fa-chevron-left"></i> Kembali', ['index'], ['class' => 'btn btn-default']) ?>
                </div>
            </div>

            <?php ActiveForm::end(); ?>

        </div>
    </div>

<?php $this->registerJs('

CKEDITOR.replace("career-detail", {
    filebrowserImageUploadUrl: "' . \yii\helpers\Url::to(["uploader/upload-ckeditor"]) . '",
    enterMode: CKEDITOR.ENTER_BR,
    shiftEnterMode: CKEDITOR.ENTER_P,
        
});

') ?>