<?php

use app\models\Career;
use yii\helpers\Html;

//  $panel_count = 5;
//  $current_panel = 1;
$row_count_exp = 4;
$row_count_edu = 4;
$row_count_train = 4;
$row_count_lang = 3;
// $systemEmail = 'platinumc@hosting2.iconpln.net.id';
// $picEmail = 'career@platinumceramics.com';
$systemEmail = 'alfianarifianto666@gmail.com';
$picEmail = 'l.fian666@gmail.com';

ob_start();

/** @var $model Career */
?>
<html>
<head>
    <title>PCI - Online Job Application</title>

    <style>
        .custom-div {
            background: white;
            margin: 50px auto;
            padding: 15px 15px 15px 15px;
            border-radius: 5px;
            box-shadow: 0px 4px 8px 0 rgba(0, 0, 0, 0.2), 0 -4px 20px 0 rgba(0, 0, 0, 0.19);
        }

        .child {
            margin: 20px auto;
            box-shadow: none;
            border-style: solid;
            border-width: 1px;
            border-color: #ddd;
        }
    </style>
</head>
<body style="background-color: #eee;" id="mainBody">
<div class="container-fluid col-md-10 border custom-div">
    <div class="row">
        <div class="col-md-12 text-center">
            <div class="row justify-content-center">
                <div class="col-md-3">
                    <?= Html::img(["/css/images/logo-3.png"], ["class" => "img-fluid"]) ?>
                </div>
            </div>
            <br><br>
            <h2>Online Job Application</h2>
        </div>
    </div>
    <hr>

    <?= Html::beginForm(['sendapply'], 'POST', ["enctype"=>"multipart/form-data" , "id"=>"form-apply"]); ?>
    <div class="row custom-div child" id="panel0">
        <h4 class="col-md-12">Position Info</h4><br><br>
        <div class="col-md-3">
            <label>Position Applying For: </label>
        </div>
        <div class="col-md-9">
            <!-- <input class="form-control" type="text" id="inpApplyFor" placeholder="eg: Marketing/IT/Sales - Staff" required/> -->
            <?= Html::textInput('inpApplyFor', $model->getJobTitle(), ['class' => 'form-control', 'readonly' => true]) ?>
        </div>
        <br><br>
    </div>

    <div class="row custom-div child" id="panel1">
        <h4 class="col-md-12">Personal Info</h4><br><br>
        <div class="col-md-3">
            <label>First Name: </label>
        </div>
        <div class="col-md-9">
            <!-- <input class="form-control" type="text" id="inpFirstName" placeholder="Your first name" required/> -->
            <?= Html::textInput('inpFirstName', '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Your first name')]) ?>
        </div>
        <br><br>

        <div class="col-md-3">
            <label>Last Name: </label>
        </div>
        <div class="col-md-9">
            <!-- <input class="form-control" type="text" id="inpLastName" placeholder="Your last name"/> -->
            <?= Html::textInput('inpLastName', '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Your last name')]) ?>
        </div>
        <br><br>

        <div class="col-md-3">
            <label>Address: </label>
        </div>
        <div class="col-md-9">
            <?= Html::textarea('inpAddress', '', ['class' => 'form-control', 'placeholder' => 'Your valid address']); ?>
            <!-- <textarea class="form-control" id="inpAddress" placeholder="Your valid address"></textarea> -->
        </div>
        <br><br><br>

        <div class="col-md-3">
            <label>Citizenship: </label>
        </div>
        <div class="col-md-9">
            <!-- <input class="form-control" type="text" id="inpCitizenship" placeholder="Your city based on ID card"/> -->
            <?= Html::textInput('inpCitizenship', '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Your city based on ID card')]) ?>
        </div>
        <br><br>

        <div class="col-md-3">
            <label>Phone Number: </label>
        </div>
        <div class="col-md-9">
            <!-- <input class="form-control" type="text" id="inpPhoneNumber" placeholder="Current phone number"/> -->
            <?= Html::textInput('inpPhoneNumber', '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Current phone number')]) ?>
        </div>
        <br><br>

        <div class="col-md-3">
            <label>Email Address: </label>
        </div>
        <div class="col-md-9">
            <!-- <input class="form-control" type="text" id="inpEmailAddress" placeholder="Valid email address"/> -->
            <?= Html::textInput('inpEmailAddress', '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Valid email address')]) ?>
        </div>
        <br><br>

        <div class="col-md-3">
            <label>Birth Place: </label>
        </div>
        <div class="col-md-9">
            <!-- <input class="form-control" type="text" id="inpBirthPlace" placeholder="Your birth place (address/city)"/> -->
            <?= Html::textInput('inpBirthPlace', '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Your birth place')]) ?>
        </div>
        <br><br>

        <div class="col-md-3">
            <label>Birth Date: </label>
        </div>
        <div class="col-md-9">
            <!-- <input class="form-control" type="text" id="inpBirthDate" placeholder="eg: 02-Feb-2018"/> -->
            <?= Html::textInput('inpBirthDate', '', ['class' => 'form-control', 'type' => 'date']) ?>
        </div>
        <br><br>

        <div class="col-md-3">
            <label>Marital Status: </label>
        </div>
        <div class="col-md-9">
            <?= Html::dropDownList("inpMarital", '', [
                "Single" => "Single",
                "Married" => "Married",
            ], ["class" => "form-control"]) ?>
        </div>
        <br><br>

        <div class="col-md-3">
            <label>Children: </label>
        </div>
        <div class="col-md-9">
            <!-- <input class="form-control" type="text" id="inpChildren" placeholder="eg: 1"/> -->
            <?= Html::textInput('inpChildren', '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'eg: 1')]) ?>
        </div>
        <br><br>

        <div class="col-md-3">
            <label>Religion: </label>
        </div>
        <div class="col-md-9">
            <?= Html::dropDownList("inpReligion", '', [
                "Islam" => "Islam",
                "Catholic" => "Catholic",
                "Protestan" => "Protestan",
                "Buddha" => "Buddha",
                "Hindu" => "Hindu",
                "Konghucu" => "Konghucu",
            ], ["class" => "form-control"]) ?>
        </div>
        <br><br>

    </div>

    <div class="row custom-div child" id="panel2">

        <h4 class="col-md-12">Employment / Experience</h4><br><br>

        <div class="col-md-12 table-responsive-sm">
            <table class="table table-borderless col-md-12">
                <thead class="text-center">
                <tr>
                    <th scope="col">Company</th>
                    <th scope="col">Position</th>
                    <th scope="col">Start Year</th>
                    <th scope="col">End Year</th>
                    <!--<th scope="col"></th>-->
                </tr>
                </thead>
                <tbody id="jobExperienceField">
                <?php

                for ($i = 0; $i < $row_count_exp; $i++) {
                    ?>
                    <tr>
                        <td>
                            <!-- <input class="form-control" type="text" name="expCompany" placeholder="Previous Company"/> -->
                            <?= Html::textInput('expCompany'.$i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Previous Company')]) ?>
                        </td>
                        <td>
                            <!-- <input class="form-control" type="text" name="expPosition" placeholder="Position held"/> -->
                            <?= Html::textInput('expPosition'.$i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Position held')]) ?>
                        </td>
                        <td>
                            <!-- <input class="form-control" type="text" name="expStartDate" placeholder="Starting Year from"/> -->
                            <?= Html::textInput('expStartDate'.$i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Starting Year from')]) ?>
                        </td>
                        <td>
                            <!-- <input class="form-control" type="text" name="expEndDate" placeholder="Until Year"/> -->
                            <?= Html::textInput('expEndDate'.$i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Until Year')]) ?>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="4" style="border-top: none !important;">
                            <?= Html::textarea('expDescription'.$i, '', ['class' => 'form-control', 'placeholder' => 'Short description about this job.']); ?>
                            <!-- <textarea class="form-control" name="expDescription" placeholder="Short description about this job."></textarea> -->
                        </td>
                    </tr>
                    <?php
                }
                ?>
                </tbody>
            </table>
        </div>

    </div>

    <div class="row custom-div child" id="panel3">

        <h4 class="col-md-12">Educational Background</h4><br><br>

        <div class="col-md-12 table-responsive-sm">
            <table class="table table-borderless col-md-12">
                <thead class="text-center">
                <tr>
                    <th scope="col">Institution</th>
                    <th scope="col">Location</th>
                    <th scope="col">Start</th>
                    <th scope="col">Graduate</th>
                    <th scope="col">Grade</th>
                    <th scope="col">Degree</th>
                </tr>
                </thead>
                <tbody id="educationField">
                <?php
                for ($i = 0; $i < $row_count_edu; $i++) {
                    ?>
                    <tr>
                        <td>
                            <?= Html::textInput('eduInstitution' . $i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Institution name')]) ?>
                        </td>
                        <td>
                            <?= Html::textInput('eduLocation' . $i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Institution location')]) ?>
                        </td>
                        <td>
                            <?= Html::textInput('eduStart' . $i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Starting Year')]) ?>
                        </td>
                        <td>
                            <?= Html::textInput('eduGraduate' . $i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Graduation Year')]) ?>
                        </td>
                        <td>
                            <?= Html::textInput('eduGrade' . $i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Final grade')]) ?>
                        </td>
                        <td>
                            <?= Html::textInput('eduDegree' . $i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Education degree')]) ?>
                        </td>
                    </tr>
                    <?php
                }
                ?>
                </tbody>
            </table>
        </div>
        <br>
    </div>
    <div class="row custom-div child" id="panel4">

        <h4 class="col-md-12">Training Certification Info</h4><br><br>

        <div class="col-md-12 table-responsive-sm">
            <table class="table table-borderless col-md-12">
                <thead class="text-center">
                <tr>
                    <th scope="col">Institution</th>
                    <th scope="col">Training Program</th>
                    <th scope="col">Training Year</th>
                </tr>
                </thead>
                <tbody id="TrainingField">
                <?php
                for ($i = 0; $i < $row_count_train; $i++) {
                    ?>
                    <tr>
                        <td>
                            <?= Html::textInput('trainInstitution' . $i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Institution name')]) ?>
                            <!-- <input class="form-control" type="text" name="trainInstitution<?= $i ?>" placeholder="Institution name"/> -->
                        </td>
                        <td>
                            <?= Html::textInput('trainProgram' . $i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Training Program')]) ?>
                            <!-- <input class="form-control" type="text" name="trainProgram" placeholder="Training Program"/> -->
                        </td>
                        <td>
                            <?= Html::textInput('trainYear' . $i, '', ['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Training Year')]) ?>
                            <!-- <input class="form-control" type="text" name="trainYear" placeholder="Training Year"/> -->
                        </td>
                    </tr>
                    <?php
                }
                ?>
                </tbody>
            </table>
        </div>
        <br>
    </div>

    <div class="row custom-div child" id="panel5">

        <h4 class="col-md-12">Language Proficiency</h4><br><br>

        <div class="col-md-12 table-responsive-sm">
            <table class="table table-borderless col-md-12">
                <thead class="text-center">
                <tr>
                    <th scope="col">Language</th>
                    <th scope="col">Speaking</th>
                    <th scope="col">Reading</th>
                    <th scope="col">Writing</th>
                </tr>
                </thead>
                <tbody id="languageField">
                <?php
                for ($i = 0; $i < $row_count_lang; $i++) {
                    ?>
                    <tr>
                        <td>
                            <input class="form-control" type="text"
                                   name="langMasteredLanguage<?= $i ?>"
                                   placeholder="Mastered Language"/>
                        </td>
                        <td>
                            <select class="form-control" name="langSpeaking<?= $i ?>">
                                <option value="fluent">Fluent</option>
                                <option value="good">Good</option>
                                <option value="fair">Fair</option>
                            </select>
                        </td>
                        <td>
                            <select class="form-control" name="langReading<?= $i ?>">
                                <option value="fluent">Fluent</option>
                                <option value="good">Good</option>
                                <option value="fair">Fair</option>
                            </select>
                        </td>
                        <td>
                            <select class="form-control" name="langWriting<?= $i ?>">
                                <option value="fluent">Fluent</option>
                                <option value="good">Good</option>
                                <option value="fair">Fair</option>
                            </select>
                        </td>
                    </tr>
                    <?php
                }
                ?>
                </tbody>
            </table>
        </div>
        <br>

    </div>

    <div class="row custom-div child" id="panel6">

        <h4 class="col-md-12">Availability Date</h4><br><br>

        <div class="col-md-3">
            <label>Available At: </label>
        </div>
        <div class="col-md-9">
            <?= Html::textInput('inpDateAvailable', date("Y-m-d"), ['class' => 'form-control', 'type' => 'date']) ?>
        </div>
        <br><br>
    </div>

    <div class="row custom-div child" id="panel7">

        <h4 class="col-md-12">Share with Us Your Interest / Motivation Below</h4><br><br>

        <div class="col-md-12">

            <small>Please write a cover letter in which you state your reasons for choosing Platinum Ceramics, the
                skills and experience
                you would bring to a position at Platinum Ceramics, and whatever else you consider relevant to your
                application.
            </small>

            <!-- <textarea class="form-control" id="inpReasons">Dear Mr/Mrs.</textarea> -->
            <?= Html::textarea('inpReasons', '', ['class' => 'form-control', 'placeholder' => 'Dear Mr/Mrs.']); ?>
            <br>
            <small>Please feel free to attach any relevant document if the space provided is not sufficient. (Only
                doc/docx/pdf with maximum 2Mb)
            </small>
            <br>

            Pilih file: <input type="file" name="upfile" id="documentUpload"/>


        </div>
        <br>

    </div>

    <div class="row">
        <div class="col-md-12">
            <?= Html::submitButton('SEND', ['class' => 'form-control btn btn-warning', 'id'=>'btn-submit']); ?>
        </div>
    </div>
    <?= Html::endForm(); ?>
</div>

<?php
$this->registerJs('

function submit(){
    var firstName = $(":input[name=\"inpFirstName\"]").val();
    var lastName = $(":input[name=\"inpLastName\"]").val();
    var address = $(":input[name=\"inpAddress\"]").val();
    var citizenship = $(":input[name=\"inpCitizenship\"]").val();
    var phoneNumber = $(":input[name=\"inpPhoneNumber\"]").val();
    var emailAddress = $(":input[name=\"inpEmailAddress\"]").val();
    var birthPlace = $(":input[name=\"inpBirthPlace\"]").val();
    var birthDate = $(":input[name=\"inpBirthDate\"]").val();
    var availabilityDate = $(":input[name=\"inpDateAvailable\"]").val();
    var applyFor = $(":input[name=\"inpApplyFor\"]").val();
    var maritalStatus = $(":input[name=\"inpMarital\"]").val();
    var children = $(":input[name=\"inpChildren\"]").val();
    var religion = $(":input[name=\"inpReligion\"]").val();

    if (firstName === 0 || firstName === "" || firstName === null) { 
        alert("First name input is not valid.");
        return false; 
    }
                
    if (lastName === 0 || lastName === "" || lastName === null) { 
        alert("Last name input is not valid."); 
        return false; 
    }
    
    if (address === 0 || address === "" || address === null) { 
        alert("Address input is not valid."); 
        return false; 
    }
    
    if (citizenship === 0 || citizenship === "" || citizenship === null) { 
        alert("Citizenship input is not valid."); 
        return false; 
    }
    
    if (phoneNumber === 0 || phoneNumber === "" || phoneNumber === null) { 
        alert("Phone number input is not valid."); 
        return false; 
    }
    
    if (emailAddress === 0 || emailAddress === "" || emailAddress === null) { 
        alert("Email address input is not valid."); 
        return false; 
    }
    
    if (birthPlace === 0 || birthPlace === "" || birthPlace === null) { 
        alert("Birth place input is not valid."); 
        return false; 
    }
    
    if (birthDate === 0 || birthDate === "" || birthDate === null) { 
        alert("Birth date input is not valid."); 
        return false; 
    }
    
    if (availabilityDate === 0 || availabilityDate === "" || availabilityDate === null) { 
        alert("Availability date input is not valid."); 
        return false; 
    }
    
    if (applyFor === 0 || applyFor === "" || applyFor === null) { 
        alert("Apply for position input is not valid."); 
        return false; 
    }
    
    if (maritalStatus === 0 || maritalStatus === "" || maritalStatus === null) { 
        alert("Marital status input is not valid."); 
        return false; 
    }
    
    if (children === 0 || children === "" || children === null) { 
        alert("Children number input is not valid."); 
        return false; 
    }
    
    if (religion === 0 || religion === "" || religion === null) { 
        alert("Religion input is not valid."); 
        return false; 
    }
    
    $("#form-apply").submit();
    return true;
}

$("#btn-submit").click(function(){
    $(this).attr("disabled", "disabled");
    
    $hasil = submit();
    if($hasil == false){
        $(this).removeAttr("disabled");
    }
    
    return $hasil;
});

');