<?php

use app\models\PageSlider;
use app\models\SettingPeta;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\View;

/** @var $this View */
$this->title = "Contact Us";

$urlDataFilter = Url::to(['contact/get-data-tabel-filter']);

?>
<style>
    .active, .filter-cabang:hover {
        background-color: #666;
        color: white;
    }

    .input-ct {
        background-color: transparent;
        border: none;
        border-bottom: 1px solid #555;
        width: 100%;
    }

    .input-ct:focus {
        border-color: #66afe9;
        background-color: transparent;
        outline: 0;
        -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075), 0 0 8px rgba(102, 175, 233, .6);
        box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075), 0 0 8px rgba(102, 175, 233, .6);
    }

    .btn-menu-c {
        text-align: left;
    }

    .btn-map {
        background: none;
        border: none;
        cursor: pointer;
        color: #4992EC;
        position: absolute;
        top: 190px;
        padding-left: 0px;
        font-weight: bold;
    }

    .description {
        height: 230px;
    }

    @media only screen
    and (max-width: 480px) {
        .btn-map {
            margin-bottom: 20px;
            position: initial;

        }

        .description {
            height: auto;
        }
    }
</style>

<div class="container-fluid mar-2">
    <div class="row">
        <div id="map" style="width:100%; height: 400px;"></div>
    </div>
</div>

<?= $this->render('@app/views/contact/header'); ?>

<div style="padding: 30px 0">
    <div class="container">
        <div class="row">
            <div class="col-md-3" id="divKategori">
                <!--<button value="All" class="a-menu-c filter-cabang" style="border:none;cursor:pointer;" type="button">
                    <div class="btn-menu-c"><?= app\models\Language::t("app", "All") ?></div>
                </button>-->

                <?php
                /** @var SettingPeta $kategori */
                foreach (SettingPeta::find()->groupBy("jenis_kantor")->all() as $kategori) {
                    ?>
                    <button class="a-menu-c filter-cabang"
                            style="border:none;cursor:pointer;"
                            jenis="<?= $kategori->jenis_kantor ?>"
                            type="button">
                        <div class="btn-menu-c"><?= app\models\Language::t("app", $kategori->jenis_kantor) ?></div>
                    </button>
                    <?php
                }
                ?>
                <br><br>
            </div>
            <div class="col-md-8">
                <div class="row" id="map-detail-info">

                </div>
            </div>
        </div>
    </div>
</div>

<div class="container-fuild" style="background-color: #eee; margin-top: 0px; margin-bottom: -100px; padding: 30px 0;" id="form-contact">
    <div class="container">
        <div class="row" style="margin-bottom: 100px;">
            <div class="col-md-3">
                <div class="row">
                    <div class="col-3 col-md-5">
                        <?= Html::img(["/image/Philosophy/icon_4.png"], ["style" => "width: 100%;"]) ?>
                        <br><br>
                    </div>
                    <div class="col-7">
                        <h4><?= app\models\Language::t("app", "Get in touch with us") ?></h4>
                    </div>
                </div>
            </div>
            <?= $this->render('_form', [
                'model' => $model,
            ]); ?>
            <div class="col-md-1" style="padding-left: 0;">
                <button onclick="topFunction()" id="myBtntop" title="Go to top"
                        style="position: absolute; bottom: 0px;">
                        <i class="fas fa-angle-double-up"></i>
                </button>
            </div>
        </div>
    </div>
</div>

<!-----------JS------------------->
<?php
$js = <<<js
    var map = null;

    function initMap() {
        var lat = -7.2659189;
        var lng = 112.7455456;
        
        if($(window).width() <= 480){
            $("#map").height(250);
        }else{
            $("#map").height(400);
        }

        //alert(parseFloat(l1));
        var myLatLng = {lat: parseFloat(lat), lng: parseFloat(lng)};

        map = new google.maps.Map(document.getElementById('map'), {
            zoom: 15,
            center: myLatLng,
            mapTypeControl: false
        });
    }

    function topFunction() {
        document.body.scrollTop = 0;
        document.documentElement.scrollTop = 0;
    }

    var infowindow = null;

    $(document).on("click", ".btn-map", function () {
        var id = $(this).val();
        var lat = $(this).attr("lat");
        var lng = $(this).attr("lng");
        var labelFlat = $(this).attr("flat");

        //alert(parseFloat(l1));
        var myLatLng = {lat: parseFloat(lat), lng: parseFloat(lng)};
        
        var marker = new google.maps.Marker({
            position: myLatLng,
            map: map,
            title: 'Lokasi'
        });
        
        map.setZoom(15);
        map.panTo(myLatLng);
        
        var jenisKantor = $(this).attr("jenis");
        
        if(infowindow != null){
            infowindow.setMap(null);
        }
        
        infowindow = new google.maps.InfoWindow({
          content: "<a style='color:#000' target='_blank' href='https://www.google.co.id/maps/place/"+encodeURIComponent(labelFlat)+"/@"+lat+","+lng+",21z'>"+$(this).closest(".info-map").find(".description").html()+"</a>"
        });
        
        infowindow.open(map, marker);
    });
    
    var firstLoad = true;
    
    $(".filter-cabang").click(function(){
        $(".filter-cabang").removeClass("active");
        $(this).addClass("active");
        var jenis = $(this).attr("jenis");
        $.ajax({
			url:"{$urlDataFilter}",
			type: "GET",
			data: {
				jenis:jenis,
			},
			success:function(data){
				$("#map-detail-info").html(data);
				
				if(firstLoad){
				    $('.btn-map:eq(0)').trigger("click");
				    
				    firstLoad = false;
				}else{
				    //scroll
				    $([document.documentElement, document.body]).animate({
                        scrollTop: $("#map-detail-info").offset().top - 20
                    }, 2000);
				}
			}
		});
    });
    
    initMap();
    $(".filter-cabang:eq(0)").trigger("click");

    $(document).ready(function(){
        // if($(window).width() <= 480){
        //     $([document.documentElement, document.body]).animate({
        //         scrollTop: $(".section-header:eq(0)").offset().top - 20
        //     }, 2000);
        // }
    });
js;
$this->registerJs($js);
?>
