<?php

use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use app\models\Language;

/**
 * @var yii\web\View $this
 * @var app\models\Apply $model
 * @var yii\widgets\ActiveForm $form
 */
?>
<style>
    .help-block{
        color: red;
        font-size: 12px;
    }
    .help-block-error{
        color: red;
        font-size: 12px;
    }
</style>
<?php $form = ActiveForm::begin([
        'id' => 'Apply',
        'enableClientScript' => false
    ]

);

if($model->hasErrors()){
    $this->registerJs('
        
        $(document).ready(function(){
            setTimeout(function(){
            //if($(window).width() <= 480){
                $([document.documentElement, document.body]).animate({
                    scrollTop: $("#form-karir").offset().top - 40
                }, 2000);
            //}
            });
        });
        
        ');
}
?>
    <div class="row" id="form-karir">
        <div class="col-12 col-md-4">
            <?= $form->field($model, 'first_name')->textInput(['class' => 'input-dl', 'placeholder' => app\models\Language::t("app", "First Name (required)"), 'required'=>true, 'style' => 'width: 100%;'])->label(false) ?>
        </div>
        <div class="col-12 col-md-4">
            <?= $form->field($model, 'last_name')->textInput(['class' => 'input-dl', 'placeholder' => app\models\Language::t("app", "Last Name (required)"), 'required'=>true, 'style' => 'width: 100%;'])->label(false) ?>
        </div>
        <div class="col-12 col-md-4">
            <?= $form->field($model, 'phone')->textInput(['class' => 'input-dl', 'placeholder' => app\models\Language::t("app", "Phone Number"), 'style' => 'width: 100%;'])->label(false) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-12 col-md-4">
            <?= $form->field($model, 'email')->textInput(['class' => 'input-dl', 'placeholder' => app\models\Language::t("app", "Youremail@mail.com"), 'style' => 'width: 100%;'])->label(false) ?>
        </div>
        <div class="col-12 col-md-4">
            <?= $form->field($model, 'position_code')->textInput(['class' => 'input-dl', 'placeholder' => app\models\Language::t("app", "Position Vacancy Code"), 'style' => 'width: 100%;'])->label(false) ?>
        </div>
        <!-- app\models\Language::t("app", "Gender") -->
        <?php
        $pria = app\models\Language::t("app", "Male");
        $wanita = app\models\Language::t("app", "Female");
        $gender = app\models\Language::t("app", "Gender");

        $list = [
            $gender => [
                $pria => $pria,
                $wanita => $wanita
            ]
        ];

        $list = [
            $pria => $pria,
            $wanita => $wanita
        ];
        ?>
        <div class="col-12 col-md-4">
            <p style="color: #777;"><?= $gender; ?></p>
            <?= $form->field($model, 'gender')->dropdownList($list)->label(False) ?>
            <?php //echo $form->field($model, 'gender')->textInput(['class' => 'input-dl', 'placeholder' => app\models\Language::t("app", "Gender"), 'style' => 'width: 100%;'])->label(false) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-12" style="margin-bottom: -50px;">
            <?= $form->field($model, 'address')->textarea(['class' => 'input-dl', 'placeholder' => app\models\Language::t("app", "Address"), 'style' => 'width: 100%;'])->label(false) ?>
        </div>
        <div class="col-12">
            <?= $form->field($model, 'id_career')->hiddenInput(['value' => $career, 'class' => 'input-dl', 'placeholder' => app\models\Language::t("app", ""), 'style' => 'width: 100%;'])->label(false) ?>
        </div>
        <div class="col-12" style="margin-bottom: 33px;">
            <label style="color:#A3A3A3;"><?= Language::t("app", 'Add your CV') ?></label>


            <div style="margin-bottom: 10px">
                <div class="custom-file">
                    <?= $form->field($model, 'file_path')->fileInput([
                        "class" => "custom-file-input"
                    ])->label(false) ?>
                    <label class="custom-file-label" for="apply-file_path"><?= Language::t("app", 'Choose File') ?></label>
                </div>
            </div>

            <?= $form->field($model, 'reCaptcha')->widget(
                \himiklab\yii2\recaptcha\ReCaptcha2::className()
            )->label(false) ?>
        </div>
        <div class="col-12">
            <?php //echo $form->field($model,'file_path')->fileinput()->label(false); ?>
        </div>
    </div>
<?php if ($model->file_path != NULL) { ?>
    <label class="col-sm-10"><?= $model->file_path ?></label>
<?php } else { ?>
    <label class="control-label col-sm-2"></label>
<?php } ?>

    <div class="row" style="margin-top: -25px;">
        <div class="col-12">
            <?= Html::submitButton("<i class='fa fa-upload'></i> " . Language::t("app", 'Submit'), ['class' => 'btn btn-lg btn-secondary']); ?>
        </div>
    </div>

    <br/>
<?php ActiveForm::end(); ?>

<?php
$this->registerJs('

$("#apply-file_path").change(function(){
    $(".custom-file-label").html($(this).val());
});

');