<?php

use yii\bootstrap\ActiveForm;
use yii\helpers\Html;

/**
 * @var yii\web\View $this
 * @var app\models\Download $model
 * @var yii\widgets\ActiveForm $form
 */

?>
    <?= Html::beginForm(['tambah'], 'POST'); ?>
        <div class="row custom-div child" id="panel0">
            
            <h4 class="col-md-12">Position Info</h4><br><br>
            
            <div class="col-md-3">
                <label>Position Applying For: </label>
            </div>
            <div class="col-md-9">
                <!-- <input class="form-control" type="text" id="inpApplyFor" placeholder="eg: Marketing/IT/Sales - Staff" required/> -->
                <?= $form->field($model, 'inpApplyFor')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'eg: Marketing/IT/Sales - Staff')])->label(false) ?>
            </div><br><br>
        </div>
            
            
        <div class="row custom-div child" id="panel1">
            
            <h4 class="col-md-12">Personal Info</h4><br><br>
            
            <div class="col-md-3">
                <label>First Name: </label>
            </div>
            <div class="col-md-9">
                <!-- <input class="form-control" type="text" id="inpFirstName" placeholder="Your first name" required/> -->
                <?= $form->field($model, 'inpFirstName')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Your first name')])->label(false) ?>
            </div><br><br>
            
            <div class="col-md-3">
                <label>Last Name: </label>
            </div>
            <div class="col-md-9">
                <!-- <input class="form-control" type="text" id="inpLastName" placeholder="Your last name"/> -->
                <?= $form->field($model, 'inpLastName')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Your last name')])->label(false) ?>
            </div><br><br>
            
            <div class="col-md-3">
                <label>Address: </label>
            </div>
            <div class="col-md-9" >
                <textarea class="form-control" id="inpAddress" placeholder="Your valid address"></textarea>
            </div><br><br><br>
            
            <div class="col-md-3">
                <label>Citizenship: </label>
            </div>
            <div class="col-md-9">
                <!-- <input class="form-control" type="text" id="inpCitizenship" placeholder="Your city based on ID card"/> -->
                <?= $form->field($model, 'inpCitizenship')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Your city based on ID card')])->label(false) ?>
            </div><br><br>
            
            <div class="col-md-3">
                <label>Phone Number: </label>
            </div>
            <div class="col-md-9">
                <!-- <input class="form-control" type="text" id="inpPhoneNumber" placeholder="Current phone number"/> -->
                <?= $form->field($model, 'inpPhoneNumber')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Current phone number')])->label(false) ?>
            </div><br><br>
            
            <div class="col-md-3">
                <label>Email Address: </label>
            </div>
            <div class="col-md-9">
                <!-- <input class="form-control" type="text" id="inpEmailAddress" placeholder="Valid email address"/> -->
                <?= $form->field($model, 'inpEmailAddress')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Valid email address')])->label(false) ?>
            </div><br><br>
            
            <div class="col-md-3">
                <label>Birth Place: </label>
            </div>
            <div class="col-md-9">
                <!-- <input class="form-control" type="text" id="inpBirthPlace" placeholder="Your birth place (address/city)"/> -->
                <?= $form->field($model, 'inpBirthPlace')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Your birth place')])->label(false) ?>
            </div><br><br>
            
            <div class="col-md-3">
                <label>Birth Date: </label>
            </div>
            <div class="col-md-9">
                <!-- <input class="form-control" type="text" id="inpBirthDate" placeholder="eg: 02-Feb-2018"/> -->
                <?= $form->field($model, 'inpBirthDate')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'eg: 02-Feb-2018')])->label(false) ?>
            </div><br><br>
            
            <div class="col-md-3">
                <label>Marital Status: </label>
            </div>
            <div class="col-md-9">
                <!-- <input class="form-control" type="text" id="inpMarital" placeholder="Married / Not Married"/> -->
                <?= $form->field($model, 'inpMarital')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Married / Not Married')])->label(false) ?>
            </div><br><br>
            
            <div class="col-md-3">
                <label>Children: </label>
            </div>
            <div class="col-md-9">
                <!-- <input class="form-control" type="text" id="inpChildren" placeholder="eg: 1"/> -->
                <?= $form->field($model, 'inpChildren')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'eg: 1')])->label(false) ?>
            </div><br><br>
            
            <div class="col-md-3">
                <label>Religion: </label>
            </div>
            <div class="col-md-9">
                <!-- <input class="form-control" type="text" id="inpReligion" placeholder="Islam/Kristen/Katholik/Budha/Hindu/Konghucu"/> -->
                <?= $form->field($model, 'inpReligion')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Islam/Kristen/Katholik/Budha/Hindu/Konghucu')])->label(false) ?>
            </div><br><br>

        </div>
        
        <div class="row custom-div child" id="panel2">
            
            <h4 class="col-md-12">Employment / Experience</h4><br><br>
            
            <div class="col-md-12 table-responsive-sm">
                <table class="table table-borderless col-md-12">
                    <thead class="text-center">
                        <tr>
                            <th scope="col">Company</th>
                            <th scope="col">Position</th>
                            <th scope="col">Start Year</th>
                            <th scope="col">End Year</th>
                            <!--<th scope="col"></th>-->
                        </tr>
                    </thead>
                    <tbody id="jobExperienceField">
                        <?php
                        
                        for ($i=0; $i<$row_count_exp; $i++) {
                        ?>
                        <tr>
                            <td>
                                <!-- <input class="form-control" type="text" name="expCompany" placeholder="Previous Company"/> -->
                                <?= $form->field($model, 'expCompany')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Previous Company')])->label(false) ?>
                            </td>
                            <td>
                                <!-- <input class="form-control" type="text" name="expPosition" placeholder="Position held"/> -->
                                <?= $form->field($model, 'expPosition')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Position held')])->label(false) ?>
                            </td>
                            <td>
                                <!-- <input class="form-control" type="text" name="expStartDate" placeholder="Starting Year from"/> -->
                                <?= $form->field($model, 'expStartDate')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Starting Year from')])->label(false) ?>
                            </td>
                            <td>
                                <!-- <input class="form-control" type="text" name="expEndDate" placeholder="Until Year"/> -->
                                <?= $form->field($model, 'expEndDate')->textInput(['class' => 'form-control', 'placeholder' => app\models\Language::t("app", 'Until Year')])->label(false) ?>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4" style="border-top: none !important;">
                                <textarea class="form-control" name="expDescription" placeholder="Short description about this job."></textarea>
                            </td>
                        </tr>
                        <?php
                        }
                        ?>
                    </tbody>
                </table>
            </div>

        </div>
        
        <div class="row custom-div child" id="panel3">
            
            <h4 class="col-md-12">Educational Background</h4><br><br>
            
            <div class="col-md-12 table-responsive-sm">
                <table class="table table-borderless col-md-12">
                    <thead class="text-center">
                        <tr>
                            <th scope="col">Institution</th>
                            <th scope="col">Location</th>
                            <th scope="col">Start</th>
                            <th scope="col">Graduate</th>
                            <th scope="col">Grade</th>
                            <th scope="col">Degree</th>
                        </tr>
                    </thead>
                    <tbody id="educationField">
                        <?php 
                            for($i=0; $i<$row_count_edu; $i++){ 
                        ?>
                        <tr>
                            <td><input class="form-control" type="text" name="eduInstitution" placeholder="Institution name"/></td>
                            <td><input class="form-control" type="text" name="eduLocation" placeholder="Institution location"/></td>
                            <td><input class="form-control" type="text" name="eduStart" placeholder="Starting Year"/></td>
                            <td><input class="form-control" type="text" name="eduGraduate" placeholder="Graduation Year"/></td>
                            <td><input class="form-control" type="text" name="eduGrade" placeholder="Final grade"/></td>
                            <td><input class="form-control" type="text" name="eduDegree" placeholder="Education degree"/></td>
                        </tr>
                        <?php
                            }
                        ?>
                    </tbody>
                </table>
            </div><br>
        </div>
        
        <div class="row custom-div child" id="panel4">
            
            <h4 class="col-md-12">Training Certification Info</h4><br><br>
            
            <div class="col-md-12 table-responsive-sm">
                <table class="table table-borderless col-md-12">
                    <thead class="text-center">
                        <tr>
                            <th scope="col">Institution</th>
                            <th scope="col">Training Program</th>
                            <th scope="col">Training Year</th>
                        </tr>
                    </thead>
                    <tbody id="TrainingField">
                        <?php 
                            for($i=0; $i<$row_count_train; $i++){ 
                        ?>
                        <tr>
                            <td><input class="form-control" type="text" name="trainInstitution" placeholder="Institution name"/></td>
                            <td><input class="form-control" type="text" name="trainProgram" placeholder="Training Program"/></td>
                            <td><input class="form-control" type="text" name="trainYear" placeholder="Training Year"/></td>
                        </tr>
                        <?php
                            }
                        ?>
                    </tbody>
                </table>
            </div><br>
        </div>
        
        <div class="row custom-div child" id="panel5">
            
            <h4 class="col-md-12">Language Proficiency</h4><br><br>
            
            <div class="col-md-12 table-responsive-sm">
                <table class="table table-borderless col-md-12">
                    <thead class="text-center">
                        <tr>
                            <th scope="col">Language</th>
                            <th scope="col">Speaking</th>
                            <th scope="col">Reading</th>
                            <th scope="col">Writing</th>
                        </tr>
                    </thead>
                    <tbody id="languageField">
                        <?php
                            for($i=0; $i<$row_count_lang; $i++) {
                        ?>
                        <tr>
                            <td><input class="form-control" type="text" name="langMasteredLanguage" placeholder="Mastered Language"/></td>
                            <td>
                                <select class="form-control" name="langSpeaking">
                                    <option value="fluent">Fluent</option>
                                    <option value="good">Good</option>
                                    <option value="fair">Fair</option>
                                </select>
                            </td>
                            <td>
                                <select class="form-control" name="langReading">
                                    <option value="fluent">Fluent</option>
                                    <option value="good">Good</option>
                                    <option value="fair">Fair</option>
                                </select>
                            </td>
                            <td>
                                <select class="form-control" name="langWriting">
                                    <option value="fluent">Fluent</option>
                                    <option value="good">Good</option>
                                    <option value="fair">Fair</option>
                                </select>
                            </td>
                        </tr>
                        <?php
                            }
                        ?>
                    </tbody>
                </table>
            </div><br>

        </div>
        
        <div class="row custom-div child" id="panel6">
            
            <h4 class="col-md-12">Availability Date</h4><br><br>
            
            <div class="col-md-3">
                <label>Available At: </label>
            </div>
            <div class="col-md-9">
                <input class="form-control" type="text" id="inpDateAvailable" placeholder="eg: 02-Feb-2018" required/>
            </div><br><br>
        </div>
        
        <div class="row custom-div child" id="panel7">
            
            <h4 class="col-md-12">Share with Us Your Interest / Motivation Below</h4><br><br>
            
            <div class="col-md-12">

                <small>Please write a cover letter in which you state your reasons for choosing Platinum Ceramics, the skills and experience 
                    you would bring to a position at Platinum Ceramics, and whatever else you consider relevant to your application.</small>
                
                <textarea class="form-control" id="inpReasons">Dear Mr/Mrs.</textarea>
                <br>
                <small>Please feel free to attach any relevant document if the space provided is not sufficient. (Only doc/docx/pdf with maximum 2Mb)</small><br>
                <form id="fileinfo" enctype="multipart/form-data" method="post" name="fileinfo">
                    Pilih file: <input type="file" name="upfile" id="documentUpload"/>
                </form>
                
                
            </div><br>

        </div>
    
        <div class="row">
            <div class="col-md-12">
                <button class="form-control btn btn-warning" onclick="send();">SEND</button>
            </div>
        </div>
<?php ActiveForm::end(); ?>