<?php

namespace app\controllers;

use app\components\NodeLogger;
use app\models\Apply;
use app\models\Applyform;
use app\models\Career;
use app\models\Language;
use Yii;
use yii\swiftmailer\Mailer;
use yii\web\UploadedFile;

class CareerController extends BaseController
{
    public function actionIndex()
    {
        return $this->render('index');
    }

    public function actionApply($id)
    {
        return $this->render('applyonline', [
            "model" => Career::find()->where(["id" => $id])->one()
        ]);
    }

    public function actionSendapply()
    {
        error_reporting(E_ALL ^ E_NOTICE);

        NodeLogger::sendLog($_POST);

        $inpApplyfor = Yii::$app->request->post('inpApplyFor');
        $inpFirstName = Yii::$app->request->post('inpFirstName');
        $inpLastName = Yii::$app->request->post('inpLastName');
        $inpAddress = Yii::$app->request->post('inpAddress');
        $inpCitizenship = Yii::$app->request->post('inpCitizenship');
        $inpPhoneNumber = Yii::$app->request->post('inpPhoneNumber');
        $inpEmailAddress = Yii::$app->request->post('inpEmailAddress');
        $inpBirthPlace = Yii::$app->request->post('inpBirthPlace');
        $inpBirthDate = Yii::$app->request->post('inpBirthDate');
        $inpMarital = Yii::$app->request->post('inpMarital');
        $inpChildren = Yii::$app->request->post('inpChildren');
        $inpReligion = Yii::$app->request->post('inpReligion');

        $exp = [];

        for ($i = 0; $i < 5; $i++) {
            $expCompany = $_POST['expCompany' . $i];
            $expPosition = $_POST['expPosition' . $i];
            $expStartDate = $_POST['expStartDate' . $i];
            $expEndDate = $_POST['expEndDate' . $i];
            $expDescription = $_POST['expDescription' . $i];
            if ($expCompany) {
                $exp[] = "
                    <tr>
                        <td>" . ($i + 1) . "</td>
                        <td>" . $expCompany . "</td>
                        <td>" . $expPosition . "</td>
                        <td>" . $expStartDate . "</td>
                        <td>" . $expEndDate . "</td>
                        <td>" . $expDescription . "</td>
                    </tr>";
            }
        }

        $institusi = [];

        for ($i = 0; $i < 5; $i++) {
            $eduInstitution = $_POST['eduInstitution' . $i];
            $eduLocation = $_POST['eduLocation' . $i];
            $eduStart = $_POST['eduStart' . $i];
            $eduGraduate = $_POST['eduGraduate' . $i];
            $eduGrade = $_POST['eduGrade' . $i];
            $eduDegree = $_POST['eduDegree' . $i];
            if ($eduInstitution) {
                $institusi[] = "
                    <tr>
                        <td>" . ($i + 1) . "</td>
                        <td>" . $eduInstitution . "</td>
                        <td>" . $eduLocation . "</td>
                        <td>" . $eduStart . "</td>
                        <td>" . $eduGraduate . "</td>
                        <td>" . $eduGrade . "</td>
                        <td>" . $eduDegree . "</td>
                    </tr>";
            }
        }

        $train = [];

        for ($i = 0; $i < 5; $i++) {
            $trainInstitution = $_POST['trainInstitution' . $i];
            $trainProgram = $_POST['trainProgram' . $i];
            $trainYear = $_POST['trainYear' . $i];
            if ($trainInstitution) {
                $train[] = "
                    <tr>
                        <td>" . ($i + 1) . "</td>
                        <td>" . $trainInstitution . "</td>
                        <td>" . $trainProgram . "</td>
                        <td>" . $trainYear . "</td>
                    </tr>";
            }
        }


        $language = [];

        for ($i = 0; $i < 5; $i++) {
            $langMasteredLanguage = $_POST['langMasteredLanguage' . $i];
            $speakingLanguange = $_POST['langSpeaking' . $i];
            $readingLanguage = $_POST['langReading' . $i];
            $writingLanguage = $_POST['langWriting' . $i];
            if ($langMasteredLanguage) {
                $language[] = "
                    <tr>
                        <td>" . ($i + 1) . "</td>
                        <td>" . $langMasteredLanguage . "</td>
                        <td>" . $speakingLanguange . "</td>
                        <td>" . $readingLanguage . "</td>
                        <td>" . $writingLanguage . "</td>
                    </tr>";
            }
        }


        $inpDateAvailable = Yii::$app->request->post('inpDateAvailable');
        $inpReasons = Yii::$app->request->post('inpReasons');

        $subject = "Platinum Ceramics Job - ".$inpApplyfor;

        $content =
            '<b>Apply Job</b>
Position : ' . $inpApplyfor . '
First Name : ' . $inpFirstName . '
Last Name : ' . $inpLastName . '
Address : ' . $inpAddress . '
Citizenship : ' . $inpCitizenship . '
Phone Number : ' . $inpPhoneNumber . '
Email Address : ' . $inpEmailAddress . '
Birth Place : ' . $inpBirthPlace . '
Birth Date : ' . $inpBirthDate . '
Marital : ' . $inpMarital . '
Children : ' . $inpChildren . '
Religion : ' . $inpReligion . '
Date Available : ' . $inpDateAvailable . '
Motivation : ' . $inpReasons . '

';
        $body = $this->renderPartial('career-email-content', [
            "content" => nl2br($content),
            "exp" => $exp,
            "institusi" => $institusi,
            "training" => $train,
            "language" => $language
        ]);

        $file = UploadedFile::getInstanceByName("upfile");
        if ($file) {
            $path = Yii::getAlias("@app/web/uploads/career/" . $file->name);
            $file->saveAs($path);
        }

        /** @var Mailer $mailer */
        $mailer = Yii::$app->mailer;

        if ($path) {
            $mailer->compose()
                ->setTo(Yii::$app->params["hrdEmail"])
                ->setFrom([Yii::$app->params["senderEmail"] => 'Platinum Ceramics Job Apply'])
                ->setSubject($subject)
                ->setHtmlBody($body)
                ->attach($path)
                ->send();
        } else {
            $mailer->compose()
                ->setTo(Yii::$app->params["hrdEmail"])
                ->setFrom([Yii::$app->params["senderEmail"] => 'Platinum Ceramics Job Apply'])
                ->setSubject($subject)
                ->setHtmlBody($body)
                ->send();
        }

        return $this->redirect(["notif-apply"]);
    }


    public function actionNotifApply()
    {
        return $this->render('notif-apply');
    }
    // public function actionSendMail()
    // {
    //     /** @var SettingKatalog $download */
    //     $download = SettingKatalog::find()->orderBy("id DESC")->one();
    //     $file_download = $download->file_path;

    //     /** @var Download $contact */
    //     $contact = Download::find()->orderBy("id DESC")->one();
    //     $nama = $contact->full_name;
    //     $email = $contact->email;
    //     $phone = $contact->phone;
    //     $subject = "Your Catalogue Is Here";

    //     $body = $this->renderPartial('send-email', [
    //         'nama' => $nama,
    //         'download' => $download,
    //         'file_download' => $file_download,
    //         'contact' => $contact,
    //         'email' => $email,
    //         'phone' => $phone,
    //         'subject' => $subject,
    //     ]);

    //     Yii::$app->mailer->compose()
    //         ->setTo($email)
    //         ->setFrom([Yii::$app->params["senderEmail"] => 'Platinum Ceramics Team'])
    //         ->setSubject($subject)
    //         ->setHtmlBody($body)
    //         ->send();

    //     return $this->redirect(["notif-apply"]);
    // }
    public function actionDetail()
    {
        Yii::$app->language = Language::getActive();

        $model = new Apply;

        try {
            if ($model->load($_POST)) {
                $file = UploadedFile::getInstance($model, 'file_path');

                if ($file != NULL) {
                    $model->file_path = $file->name;
                    $arr = explode(".", $file->name);
                    $extension = end($arr);

                    # generate a unique file name
                    $model->file_path = "upload_" . \Yii::$app->security->generateRandomString(4) . "." . $extension;

                    # the path to save file
                    $path = \Yii::getAlias("@app/web/uploads/career/") . $model->file_path;
                    $file->saveAs($path);
                }

                if ($model->save()) {
                    return $this->redirect(['send-mail']);
                }
            } elseif (!\Yii::$app->request->isPost) {
                $model->load($_GET);
            }
        } catch (\Exception $e) {
            $msg = (isset($e->errorInfo[2])) ? $e->errorInfo[2] : $e->getMessage();
            $model->addError('_exception', $msg);
        }
        return $this->render('detail', ['model' => $model]);
    }

//     public function actionSendMail()
//     {
//         // Send to email
//         /** @var Apply $contact */
//         $contact = Apply::find()->orderBy("id DESC")->one();
//         $nama = $contact->first_name . ' ' . $contact->last_name;
//         $email = $contact->email;
//         $phone = $contact->phone;
//         $adress = $contact->address;
//         $gender = $contact->gender;
//         $subject = $contact->position_code;
//         //$message = $contact->message;

//         $body = '
// Apply Job
// Name : ' . $nama . '
// Email : ' . $email . '
// Phone : ' . $phone . '
// Adress : ' . $adress . '
// Gender : ' . $gender . '

//             '; // Our message above

//         $chain = Yii::$app->mailer->compose()
//             ->setTo(Yii::$app->params["hrdEmail"])
//             ->setFrom([Yii::$app->params["senderEmail"] => 'Platinum Ceramics Job Apply'])
//             ->setSubject($subject)
//             ->setTextBody($body);
//         if ($contact->file_path) {
//             $chain->attach(\Yii::getAlias("@app/web/uploads/career/") . $contact->file_path)
//                 ->send();
//         } else {
//             $chain->send();
//         }

//         return $this->redirect(["sent-success"]);
//     }

    public function actionSentSuccess()
    {
        return $this->render('sent-success');
    }
}
