<?php

use app\models\Language;
use app\models\Product;
use app\models\ProductColor;
use app\models\ProductColorFilter;
use app\models\Suitable;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use yii\web\View;

/** @var $this View */
$this->title = "Product";
?>
    <style>
        #myDIV {
            margin-left: 0px;
        }

        .c-white {
            background-color: #fff;
            margin: 5px 0px 5px 0px;
        }

        .btn-secondary {
            border-radius: 0px;
            background-color: #eee;
            border: 0px;
            color: #777;
            width: 100%;
            height: 35px;
            text-align: left;
            margin: 7px 0px 0px 0px;
            padding: 0 0 0 11px;
        }

        .btn-secondary-sub {
            border-radius: 0px;
            background-color: #a8a8a8 !important;
            border-bottom: 0px !important;
            border: 0px;
            color: #777;
            padding: 0px;
            width: 100%;
            height: 35px;
            text-align: left;
        }

        .btn-secondary-sub:hover {
            background-color: #ddd;
            color: #333;
        }

        .active {
            background-color: #555;
            color: #aaa;
        }

        .active:hover {
            background-color: #777;
            color: #999;
        }

        .box-btn-menu {
            display: flex;
            float: right;
            border-radius: 0px;
            background-color: #fff;
            color: #777;
            padding: 0px;
            width: 25px;
            height: 25px;
            margin: 5px;
        }

        .box-btn-menu-second {
            display: flex;
            float: left;
            border-radius: 0px;
            background-color: #5d5d5d;
            color: #fff;
            padding: 0px;
            width: 25px;
            height: 25px;
            margin: 5px 30px 5px 5px;
        }

        .box-btn-menu-second:hover {
            background: #a8a8a8;
        }

        .text-btn-menu {
            margin-top: 6px;
        }

        .btn-secondary-sub .text-btn-menu {
            padding-top: 6px;
        }

        .ph-b {
            color: #333;
            padding-left: 10px;
            margin-top: 2px;
        }

        .ph-b::placeholder {
            color: #333;
            margin-left: 50px;
        }

        .image-product {
            float: left;
            width: 210px;
            height: 200px;
            margin: 5px 0px 5px -20px;
        }

        .text-image {
            text-align: right;
            color: #999;
            margin: -25px 50px 0px 0px;
            font-weight: bold;
        }

        .image-box-p {
            width: 200px;
            height: 200px;
            margin: 0px 10px 5px 0px;
        }

        .img-box-p {
            width: 175px;
            height: 175px;
            object-fit: cover;
        }

        .btn-menu-left {
            background-color: #ddd;
            border: 0px;
        }

        .btn-menu-left:hover {
            background-color: #999;
            border: 0px;
        }

        .product-desc {
            text-align: right;
            color: #000;
        }

        .filter-top {
            background: #a8a8a8;
            color: #fff;
            padding: 4px 10px;
            display: inline-block;
            margin-bottom: 21px;
            border-radius: 14px;
            font-size: 11px;
        }

        .filter-top:hover {
            color: #fff;
        }

        .load-more {
            display: block;
            text-align: center;
            width: 100%;
            background: #6c757d;
            color: #fff;
            padding: 11px;
            font-weight: bold;
        }

        .load-more:hover {
            background-color: #999;
            color: #444;
        }
    </style>

<?php
$filterOutput = [];

/** @var ProductColorFilter[] $filters */
$filters = ProductColorFilter::find()->orderBy("color")->all();
foreach ($filters as $filter) {
    $jumlah = ProductColor::find()->where(["like", "product_color.color", $filter->color])->joinWith(["product" => function ($q) use ($brand) {
        $q->andWhere(["brand" => $brand]);
    }])->count();
    if ($jumlah > 0) {
        $filterOutput[$filter->color] = $filter->color;
    }
}

$type = ArrayHelper::map(Product::find()->groupBy("type")->where(["brand" => $brand])->all(), "type", "type");
$newType = [];
foreach ($type as $key => $value){
    $newType[$key] = Language::t("app", $value);
}

$search = [
    //"Brand" => ArrayHelper::map(Product::find()->groupBy("brand")->all(), "brand", "brand"),
    //"Type" => ArrayHelper::map(Product::find()->groupBy("type")->where(["brand"=>$brand])->all(), "type", "type"),
    "Type" => $newType,
    "Finishing" => ArrayHelper::map(Product::find()->groupBy("look")->where(["brand" => $brand])->all(), "look", "look"),
    "Dimension" => ArrayHelper::map(Product::find()->groupBy("dimension")->where(["brand" => $brand])->all(), "dimension", "dimensionCm"),
    "Color" => $filterOutput,
    "Suitable" => ArrayHelper::map(Suitable::find()->all(), "id", "nama"),
];
?>

<?= $this->render("@app/views/product/description", ["brand" => $brand]) ?>

    <div style="padding: 30px 0">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-4 col-lg-3" style="margin-bottom: 15px">
                    <h4 style="font-weight: bold;color: #a8a8a8;"><?= Language::t("app", "BROWSE HERE") ?></h4>
                    <form style="margin-top: 20px;">
                        <div class="input-group mb-3">
                            <input id="search_term" type="text" class="form-control"
                                   placeholder="<?= app\models\Language::t("app", "Search") ?>"
                                   aria-label="Search" aria-describedby="basic-addon2"
                                   style="border-radius: 0px;">
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary" type="button" id="btn-search"
                                        style="border-radius: 0px;">
                                    <i class="fas fa-search"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                    <?php
                    foreach ($search as $key => $array) {
                        ?>
                        <div class="dropdown">
                            <a href="#" class="btn btn-secondary active btn-parent"
                               data-key="<?= strtolower($key) ?>"
                               data-value=""
                               data-toggle="dropdown"
                               aria-haspopup="true"
                               aria-expanded="false"
                               data-target="#div_<?= $key ?>">
                                <div class="box-btn-menu justify-content-center align-items-center">
                                    <b class="x_btn" style="display: none;"><i class="fa fa-caret-up"></i></b>
                                    <b class="p_btn"><i class="fa fa-caret-down"></i></b>
                                </div>
                                <?php
                                if ($key == "Dimension") {
                                    ?>
                                    <div class="text-btn-menu"><?= Language::t("app", "Size") ?></div>
                                    <?php
                                } else {
                                    ?>
                                    <div class="text-btn-menu"><?= Language::t("app", $key) ?></div>
                                    <?php
                                }
                                ?>
                            </a>
                            <div id="div_<?= $key ?>" class="dropdown-parent" style="display: none;">

                                <a href="#" class="btn btn-secondary-sub dropdown-item"
                                   data-content=""
                                   data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <div class="box-btn-menu-second justify-content-center align-items-center">
                                        <b><i class="fa fa-check"></i></b>
                                    </div>
                                    <div class="text-btn-menu"><?= Language::t("app", "ALL") ?></div>
                                </a>

                                <?php
                                foreach ($array as $key => $item) {
                                    ?>
                                    <a href="#" class="btn btn-secondary-sub dropdown-item"
                                       data-content="<?= $key ?>"
                                       data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <div class="box-btn-menu-second justify-content-center align-items-center"
                                             style="text-align: center;"><b></b>
                                        </div>
                                        <?php
                                        if ($key == "GLOSSY") {
                                            ?>
                                            <span class="label2-white" style="position: static; float: left; margin: 6px 7px 0px 0px;">G</span><div class="text-btn-menu" style="float: left; margin-top: 1px;"><?= $item ?>
                                            </div>
                                            <?php
                                        } else if ($key == "MATT") {
                                            ?>
                                            <span class="label2-black" style="position: static; float: left; margin: 6px 7px 0px 0px;">M</span><div class="text-btn-menu" style="float: left; margin-top: 1px;"><?= $item ?>
                                            </div>
                                            <?php
                                        } else {
                                            ?>
                                            <div class="text-btn-menu"><?= $item ?></div>
                                            <?php
                                        }
                                        ?>
                                    </a>
                                    <?php
                                }
                                ?>

                            </div>
                        </div>
                        <?php
                    }
                    ?>
                </div>
                <div class="col-sm-12 col-md-8 col-lg-9" style="padding-top: 44px;" id="detail-product">
                    Loading ...
                </div>
            </div>
        </div>
    </div>

<?php
$ajaxUrl = Url::to(["index-ajax"]);
$brandEncode = urlencode($brand);

$js = <<<js

$(".btn-parent").click(function(){
    var target = $(this).attr("data-target");
    
    $(".btn-parent").each(function(){
        var currentTarget = $(this).attr("data-target");
        console.log(currentTarget);
        if(currentTarget != target){
            $(currentTarget).hide(500);
            $(this).find(".p_btn").show();
            $(this).find(".x_btn").hide();
        }else{
            $(target).toggle(500);
            $(this).find(".p_btn").toggle();
            $(this).find(".x_btn").toggle();
        }
    });
    
    return false;
});

$(".btn-secondary-sub").click(function(){
    var wrapper = $(this).closest(".dropdown-parent");
    wrapper.find("b").html("");
    
    $(this).find("b").html("<i class=\"fa fa-check\"></i>");
    
    $(this).closest(".dropdown").find(".btn-parent").attr("data-value", $(this).attr("data-content"));
    
    var parent = $(this).closest(".dropdown").find(".btn-parent");
    var target = parent.attr("data-target");
    $(target).hide(500);
    parent.find(".p_btn").show();
    parent.find(".x_btn").hide();
    
    refreshSearching();
    return false;
});


$("#search_term").keypress(function(e){
    console.log(e);
    if(e.charCode == 13){
        refreshSearching(1);
        return false;
    }
});

$("#btn-search").click(function(){
    refreshSearching(1);
    return false;
});

var currentPage = 1;

function refreshSearching(page){
    if(page == null){
        page = 1;
    }
    currentPage = page;
    var arr = new Array();
    $(".btn-parent").each(function(){
        var attr = $(this).attr("data-key");
        var val = $(this).attr("data-value");
        arr.push(attr + "=" + encodeURI(val));
    });
    var quer = arr.join("&");
    
    if(page != 1){
        $.ajax({
            url: "{$ajaxUrl}?name=" + $("#search_term").val() + "&page=" + page + "&" + quer + "&brand={$brandEncode}",
            dataType: "text",
            success: function(msg){
                $(".load-more").remove();
                
                //console.log(msg);
                
                var html = $(msg).find(".list-ajax-product").html();
                //console.log(html);
                $("#detail-product").append(msg);
            }
        });
    }else{
        $("#detail-product").load("{$ajaxUrl}?name=" + $("#search_term").val() + "&page=" + page + "&" + quer + "&brand={$brandEncode}");
    }
}

refreshSearching(1);

$(document).on("click", ".filter-name", function(){
    $("#search_term").val("");
    refreshSearching(1);
    return false;
});

$(document).on("click", ".filter-finishing", function(){
    $("#div_Finishing a:eq(0)").trigger("click");
    return false;
});

$(document).on("click", ".filter-type", function(){
    $("#div_Type a:eq(0)").trigger("click");
    return false;
});

$(document).on("click", ".filter-dimension", function(){
    $("#div_Dimension a:eq(0)").trigger("click");
    return false;
});

$(document).on("click", ".filter-color", function(){
    $("#div_Color a:eq(0)").trigger("click");
    return false;
});

$(document).on("click", ".filter-suitable", function(){
    $("#div_Suitable a:eq(0)").trigger("click");
    return false;
});

$(document).on("click", ".load-more", function(){
    refreshSearching(currentPage + 1);
    return false;
});

$(".btn-parent:eq(0)").trigger("click");

js;
$this->registerJs($js);