<?php

use app\components\Util;
use app\models\Language;
use app\models\ProductColor;
use app\models\Suitable;
use yii\helpers\Html;
use yii\helpers\Url;

?>
    <style>
        .text-ph {
            color: #444;
            margin: -40px 0px 20px 0px;
            position: absolute;
        }

        @media only screen and (max-width: 480px) {
            .text-ph {
                margin: -31px 0px 0px 0px;
            }
        }
    </style>

<?php
/** @var $results ProductColor[] */
if ($page == 1) {
    ?>
    <div class="text-ph">
        <span class="label2-white" style="float: left; margin-right: 3px;">G</span>
        <p style="float: left;">GLOSSY</p><span class="label2-black" style="float: left; margin-right: 3px;">M</span>
        <p style="float: left;">MATT</p>
    </div>
    <div class="filter-top-product">
        <?php if ($_GET['name'] != "") { ?>
            <?= Html::a(Language::t("app", "Search Term") . " : " . Language::t("app", $_GET['name']) . " <i class='fa fa-times'></i>", "#", ["class" => "filter-top filter-name"]) ?>
        <?php } ?>
        <?php if ($_GET['type'] != "") { ?>
            <?= Html::a(Language::t("app", "Type") . " : " . Language::t("app", $_GET['type']) . " <i class='fa fa-times'></i>", "#", ["class" => "filter-top filter-type"]) ?>
        <?php } ?>
        <?php if ($_GET['finishing'] != "") { ?>
            <?= Html::a(Language::t("app", "Finishing") . " : " . Language::t("app", $_GET['finishing']) . " <i class='fa fa-times'></i>", "#", ["class" => "filter-top filter-finishing"]) ?>
        <?php } ?>

        <?php if ($_GET['dimension'] != "") { ?>
            <?= Html::a(Language::t("app", "Size") . " : " . Language::t("app", $_GET['dimension']) . " <i class='fa fa-times'></i>", "#", ["class" => "filter-top filter-dimension"]) ?>
        <?php } ?>

        <?php if ($_GET['color'] != "") { ?>
            <?= Html::a(Language::t("app", "Color") . " : " . Language::t("app", $_GET['color']) . " <i class='fa fa-times'></i>", "#", ["class" => "filter-top filter-color"]) ?>
        <?php } ?>

        <?php if ($_GET['suitable'] != "") {
            /** @var Suitable $suitable */
            $suitable = Suitable::find()->where(["id" => $_GET['suitable']])->one();
            ?>
            <?= Html::a(Language::t("app", "Suitable") . " : " . $suitable->getNama() . " <i class='fa fa-times'></i>", "#", ["class" => "filter-top filter-suitable"]) ?>
        <?php } ?>

    </div>
    <?php
}
?>
    <div class="row list-ajax-product">
        <?php

        foreach ($results as $result) {
            $img = $result->image_path;
            $product = $result->product;
            if ($img == "" || !file_exists(Yii::getAlias("@app/web/uploads/product/" . $result->image_path))) {
                if ($product->brand == "PLATINUM") {
                    $img = "default.png";
                } else {
                    $img = "default-as.png";
                }
            }
            $id = $result->id;
            $bg = $product->look == "MATT" ? "black" : "white";

            $brandSlug = Util::slugify($product->name);
            $productSlug = Util::slugify($result->color);
            ?>
            <div class="col-6 col-md-6 col-lg-4 col-xl-3">
                <a href="<?= Url::to(["/product/" . $id . "/" . $brandSlug . "/" . $productSlug]) ?>">
                    <div class="product-badge">
                        <span class="label-<?= $bg ?>"><?= $product->dimension ?></span>
                        <span class="label-<?= $bg ?>"><?= $product->look == "MATT" ? "M" : "G" ?></span>
                    </div>
                    <?= Html::img(["/uploads/product/" . $img], ["class" => "product-image"]) ?>
                    <div class="product-description">
                        <h1><?= $product->name ?></h1>
                        <p><?= $result->color ?></p>
                    </div>
                </a>
            </div>
            <?php
        }


        if (count($results) == 0 && $page == 1) {
            ?>
            <div class="col-md-12" style="display: flex;justify-content: center;align-items: center;flex-direction: column;height: 200px">
                <?= Html::img(["/css/images/icon-notfound.png"], ["style" => "width: 100px;margin-bottom: 20px"]) ?>
                <p style="font-size: 16px;color: #999;"><?= Language::t("app", "Product Not Found") ?></p>
            </div>
            <?php
        }
        ?>


    </div>

<?php
if ($showLoadMore) {
    echo Html::a("<i class='fas fa-sync'></i> " . (Language::getActive() == Language::INDONESIA ? "Tampilkan Lebih Banyak" : "Load More"), "#", ["class" => "load-more"]);
}
