<?php

use app\components\Photo;
use app\models\Inspiration;
use app\models\InspirationDetail;
use app\models\Language;
use app\models\Product;
use app\models\ProductColor;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\View;

/** @var $this View */


//ubah ke int untuk prevent sql injection
$id = intval($id);
$insget = @$_GET['ins'];
/** @var ProductColor $result */
$result = ProductColor::find()->where(["id" => $id])->one();
$product = $result->product;
$idpro = $result->product_id;
//echo $idpro;
$resultpro = Product::find()->where(["id" => $idpro])->one();

//echo $resultpro->name;
$fileName = "";

if ($result->image_path) {
    $fileName = $result->image_path;
}

if ($fileName == "" || !file_exists(Yii::getAlias("@app/web/uploads/product/" . $fileName))) {
    if ($product->brand == "PLATINUM") {
        $fileName = "default.png";
    } else {
        $fileName = "default-as.png";
    }
}

$this->title = "Product - ".$product->name." ".$result->color;
?>

<?= $this->render("@app/views/product/description", ["brand" => $product->brand]) ?>

<style>
    .black-box {
        background: #a8a8a8;
        border: 0px;
        color: #fff;
        width: 50px;
        height: 50px;
        display: flex;
        justify-content: center;
        align-items: center;
        margin-ri ght: 5px;
        border-radius: 5px;
        margin-top: 5px;
    }

    .black-box:hover {
        text-decoration: none;
        color: #fff;
        background-color: #444;
    }

    .black-box-fluid {
        width: 180px;
        padding-left: 0px;
        padding-right: 0px;
    }

    .black-box-fluid:hover {
        text-decoration: none;
        color: #fff;
        background-color: #444;
    }

    .black-box i {
        font-size: 24px;
    }

    .img-fluid:hover {
        text-decoration: underline;
    }
    .figure-caption:hover {
        text-decoration: underline; 
    }

    .hov-cus {
        cursor: zoom-in;
    }

    .hov-cus:hover {
        cursor: zoom-in;
    }
    .textjudulp{
        font-weight: bold;
        font-size: 26px;
        margin-top:-10px;
    }
    @media only screen and (max-width: 750px) {
        .textjudulp{
            margin-top: 0px;
        }
    }
</style>

<?php

if ($product->brand == "PLATINUM") {
    $logo = Url::to(['/css/images/logo-5.png']);
} else {
    $logo = Url::to(['/css/images/logo-4-b.png']);
}

//Ubah logo product
$this->registerJs('

$(".navbar-brand img").attr("src", "' . $logo . '");

');

Yii::$app->params["ogImage"] = Url::to(["/thumb/product/".$fileName], true);
?>

<div style="padding: 30px 0">
    <div class="container">
        <div class="row">
            <div class="col-md-5">
                <div class="xzoom-container">
                    <?= Html::img(Photo::get($fileName, "product"), ["class" => "img-fluid", "id" => "zoom-produk", "xoriginal" => Photo::get($fileName, "product")]) ?>
                </div>
                <?php

                $this->registerJs('
                
                $(document).ready(function(){
                    setTimeout(function(){
                        if($(window).width() > 480){
                            $(".xzoom-container").zoom();
                        }else{
                            $("head meta[name=viewport]").attr("width=device-width,initial-scale=1");
                            console.log("Remove ZOOM");
                        }   
                    }, 1000);
                })
                
                ');
                ?>
            </div>
            <div class="col-md-7">
                <p class="textjudulp"><?= $product->name . " " . $result->color; ?></p>
                <table>
                    <tr>
                        <td width="100px"><?= app\models\Language::t("app", "Type"); ?></td>
                        <td width="20px">:</td>
                        <td><?= $product->type ?></td>
                    </tr>
                    <tr>
                        <td><?= app\models\Language::t("app", "Brand"); ?></td>
                        <td>:</td>
                        <td><?= $product->brand ?></td>
                    </tr>
                    <tr>
                        <td><?= app\models\Language::t("app", "Color"); ?></td>
                        <td>:</td>
                        <td><?= $result->color ?></td>
                    </tr>
                    <tr>
                        <td><?= app\models\Language::t("app", "Finish"); ?></td>
                        <td>:</td>
                        <td><?= $product->look ?></td>
                    </tr>
                    <tr>
                        <td><?= app\models\Language::t("app", "Size"); ?></td>
                        <td>:</td>
                        <td><?= $product->dimension ?> cm</td>
                    </tr>
                </table>


                <div class="row">
                    <div class="col">
                        <?php
                        if ($insget == "") {
                            ?>
                            <div class="col" style="margin-top: 20px;">
                            </div>
                            <?php
                        } else {
                            /** @var Inspiration $inspiration */
                            $inspiration = Inspiration::find()->where(["id"=>$insget])->one();
                            ?>
                            <a href="<?= $inspiration->getUrl() ?>"
                               class="black-box black-box-fluid"><?= app\models\Language::t("app", "Back To Inspiration"); ?></a>
                            <br/>
                            <?php
                            //echo $insget;
                        }
                        ?>
                        <?= app\models\Language::t("app", "Share this product"); ?>
                        <br/>

                        <?php
                        $text = "";
                        if($product->brand == "PLATINUM"){
                            $text = Language::t("app", "Check out this product from Platinum Ceramics").", ".$product->name." ".$result->color;
                        }else{
                            $text = Language::t("app", "Check out this product from Asia Tile").", ".$product->name." ".$result->color;
                        }
                        ?>

                        <?= \app\components\ShareButton::widget([
                            "position" => "bottom",
                            "text" => $text,
                            "url" => Url::current([], true),
                            "buttonClass" => "btn black-box"
                        ]) ?>

                    </div>
                    <?php
                    if ($insget == ""){
                    ?>
                    <div class="col" style="margin-top: 22px;">
                        <?php
                        }else{
                        ?>
                        <div class="col" style="margin-top: 75px;">
                            <?php
                            }
                            ?>
                            <?= app\models\Language::t("app", "Ask this product"); ?>
                            <br>
                            <div style="display: flex;flex-direction: row">
                                <!-- 
                                    62315312358
                                    admin@platinumceramics.com
                                 -->
                                <a href="https://wa.me/62315312358?text=<?= urlencode(\app\models\Language::t("app", "Hi, I would like to ask more about")) ?>+<?= $resultpro->name ?>+<?= $result->color ?>+!+<?= Url::current([], true) ?>+"
                                   class="black-box" target="blank">
                                    <i class="fab fa-whatsapp"></i>
                                </a>
                                <a href="mailto:admin@platinumceramics.com?body=<?= \app\models\Language::t("app", "Hi, I would like to ask more about") ?> <?= $resultpro->name ?> <?= $result->color ?> ! <?=  Url::current([], false) ?>"
                                   class="black-box" target="blank" style="margin-left: 10px;">
                                    <i class="far fa-envelope"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container" style="padding-top: 40px">
            <div class="row justify-content-center">
                <div class="col-12">
                    <h3><?= app\models\Language::t("app", "Related Products"); ?></h3>
                    <br/>
                    <div class="row">
                        <?php
                        /** @var ProductColor[] $relatedProducts */
                        $relatedProducts = ProductColor::find()->where(["product_id" => $product->id])->andWhere("id != " . $id)->all();

                        foreach ($relatedProducts as $color) {
                            $product = $color->product;

                            $img = $color->image_path;
                            if ($img == "" || !file_exists(Yii::getAlias("@app/web/uploads/product/" . $img))) {
                                if ($product->brand == "PLATINUM") {
                                    $img = "default.png";
                                } else {
                                    $img = "default-as.png";
                                }
                            }

                            ?>
                            <div class="col-6 col-md-2">
                                <a href="<?= $color->getUrl() ?>" style="width: 100%">
                                    <figure class="figure">
                                        <img src="<?= Url::to(["/uploads/product/" . $img]) ?>"
                                             class="figure-img img-fluid">
                                        <figcaption class="figure-caption" style="text-align: right">
                                            <?= $product->name . " " . $color->color ?>
                                        </figcaption>
                                    </figure>
                                </a>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
        if ($product->brand == "PLATINUM") {
            //$command = InspirationDetail::find()->where(["product_color_id" => $id])->all();
            //$insjmlh = InspirationDetail::find()->where(["product_color_id" => $id])->count();
            //echo $insjmlh;
            ?>
            <div class="container" style="padding-top: 20px">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <?= $this->render("@app/views/layouts/component/product-inspiration", [
                            "id" => $id
                        ]) ?>
                    </div>
                </div>
            </div>
            <?php
        } else {
            $insid = InspirationDetail::find()->where(["product_color_id" => $id])->all();
            //$row = $insid->queryAll();
            if ($insid) {
                ?>
                <div class="container" style="padding-top: 20px">
                    <div class="row justify-content-center">
                        <div class="col-12">
                            <?= $this->render("@app/views/layouts/component/product-inspiration", [
                                "id" => $id
                            ]) ?>
                        </div>
                    </div>
                </div>
                <?php
            } else {

            }
        }
        ?>

    </div>