<?php

use app\components\Photo;
use app\components\Tanggal;
use app\models\News;
use yii\helpers\Html;
use app\models\Language;
use yii\helpers\Url;
use yii\web\View;

/** @var $this View */
/** @var $model News */
$this->title = $model->getTitle();
//$this->title = "News";
?>
<style>
    .box-left {

    }
    .black-box-l {
        float: right;
        text-align: right;
        background: #a8a8a8;
        border: 0px;
        color: #fff;
        width: 40px;
        height: 40px;
        justify-content: center;
        align-items: center;
        margin-right: 0px;
        border-radius: 5px;
        margin-top: 5px;
        padding-right: 13px;
    }

    .black-box-l:hover {
        text-decoration: none;
        color: #fff;
    }

    .black-box-l i {
        font-size: 24px;
    }
    .color-a{
        color: black;
    }
    .color-a:hover{
        color: #000;
    }
    .text-size-oc{
        font-size: 5px;
    }
    .black-box {
        background: #a8a8a8;
        border: 0px;
        color: #fff;
        width: 50px;
        height: 50px;
        display: flex;
        justify-content: center;
        align-items: center;
        margin-right: 5px;
        border-radius: 5px;
        margin-top: 5px; 
    }

    .black-box:hover {
        text-decoration: none;
        color: #fff;
        background-color: #444;
    }
    .view1a{display: block;}
    .view2a{display: none;}
    @media only screen and (max-width: 559px) {
        .view1a{display: none;}
        .view2a{display: block;}
    }
    .link {
        color: #000;
        text-decoration: underline;
    }

    ul {
        padding-left: 13px;
    }

    ul li {
        float: none;
    }

    .table tr:first-child th, .table tr:first-child td {
        border-top: 0px;
    }
</style>
<?= $this->render('@app/views/news/header'); ?>
<div style="padding: 30px 0">
    <div class="container">
        <div class="row h-mn konten-news">
            <h3></h3>
            <div class="col-md-8" style="text-align: justify">
                <div class='row'>
                    <div class='col-10' style="padding-top: 4px;">
                        <h1 style="font-size: 25px;font-weight: bold"><?= $model->getTitle() ?></h1>
                    </div>
                    <div class="col-2" style="text-align: right;padding-top: 4px;">
                        <?= \app\components\ShareButton::widget([
                            "position" => "left",
                            "text" => $this->title,
                            "url" => Url::current([], true)
                        ]) ?>
                    </div>
                </div>
                <?php
                Yii::$app->params["ogImage"] = Url::to(["/thumb/news/".$model->thumbnail_url], true);
                ?>

                <?= Html::img(Photo::get($model->thumbnail_url, "news"), ["class" => "img-fluid", "style" => "margin-top:10px"]) ?>
                <hr/>

                <?= $model->getContent() ?>
                <div class="row view1a" style="margin-bottom: 20px;">
                    <div class="col-12 col-sm-2">
                        <a href="<?= Url::to(['/news']) ?>" class="black-box-l" style="margin-right: 5px; float: left; padding-top: 7px; padding-left: 4px;">
                            <i class="fas fa-chevron-left" style="font-size: 19px; padding-top: 3px;"></i>
                            <!--<?= app\models\Language::t("app", "Back"); ?>-->
                        </a>
                        
                    </div>
                    <div class='col-12 col-sm-10' style="text-align: right;">

                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="box-left">
                    <?php
                        $ids = $model->news_category_id;
                        if ($ids == 1){
                            $news = "Articles";
                        }else if($ids == 2){
                            $news = "Events";
                        }
                    ?>
                    <h4 style="margin-bottom: 27px">
                        <?= app\models\Language::t("app", "Other News & Events"); ?>
                    </h4>
                    <?php
                    /** @var News[] $listBerita */
                    $listBerita = News::find()->where(["news_category_id" => $ids])->orderBy("id DESC")->limit(4)->all();
                    foreach ($listBerita as $berita) {
                        ?>
                        <a href="<?= Url::to(["/news/" . $berita->slug]) ?>" class="color-a">
                            <div class="media" style="margin-bottom: 10px">
                                <img class="mr-3" src="<?= Url::to(Photo::get($berita->thumbnail_url, "news")) ?>"
                                     style="width: 60px"
                                     alt="<?= $berita->getTitle() ?>"/>
                                <div class="media-body">
                                    <h6 class="mt-0"><?= $berita->getTitle() ?></h6>
                                    <?php echo Tanggal::toReadableDate($berita->created_at, false ,true); ?>
                                </div>
                            </div>
                        </a>
                        <?php
                    }
                    ?>
                </div>
                <div class="box-left">
                    <h3><?= app\models\Language::t("app", "Archive"); ?></h3>

                    <ul>
                        <?php
                        for ($i = 0; $i <= 12; $i++) {
                            $tanggal = strtotime("-" . $i . " month");

                            echo "<li>" . Html::a(date("M Y", $tanggal), ["/archive", "filter" => date("Y-m-01", $tanggal)], ["class" => "link"]) . "</li>";
                        }
                        ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$this->registerJs('

$([document.documentElement, document.body]).animate({
    scrollTop: $(".konten-news h3:eq(0)").offset().top - 20
}, 2000);

');