<?php

use app\components\Photo;
use app\components\Tanggal;
use app\models\Language;
use app\models\News;
use yii\helpers\Url;

$q = $_GET['q'];
?>

<style>
    .new-search-text {
        color: #999;
    }

    .title-page {
        padding-top: 1px;
        padding-bottom: 10px;
    }

    .title-page h1 {
        font-weight: bold;
    }

    h3 {
        padding-bottom: 15px;
    }

    .text-news-result {
        font-size: 14px;
        font-weight: bold;
        color: #000;
        padding-bottom: 10px;
        display: block;
    }
</style>

<h3> <?= app\models\Language::t("app", "Search Result") ?> : <?= $q ?></h3>

<div class="row">
    <?php
    $news = News::find()
        ->where([
            "or",
            ["like", "news.title_indonesia", $q],
            ["like", "news.title_english", $q],
            ["like", "news.content_indonesia", $q],
            ["like", "news.content_english", $q],
        ])
        ->andWhere(["status" => 1])->limit(100)->all();

    /** @var News $result */
    foreach ($news as $result) {

        ?>
        <div class="col-12">
            <a href="<?= $result->getUrl() ?>" class="text-news-result">
                <div class="media" style="margin-bottom: 10px">
                    <img class="mr-3" src="<?= Url::to(Photo::get($result->thumbnail_url, "news")) ?>"
                         style="width: 60px"
                         alt="<?= $result->getTitle() ?>">
                    <div class="media-body">
                        <h5 class="mt-0"><?= $result->getTitle() ?></h5>
                        <?= Tanggal::toReadableDate($result->created_at, false ,true); ?>
                    </div>
                </div>
            </a>
        </div>
        <?php
    }

    if (count($news) == 0) {
        ?>
        <div class="col">
            <?= Language::t("app", "News Not Found"); ?>
        </div>
        <?php
    }
    ?>
</div>