<?php

use app\components\Photo;
use app\models\Language;
use app\models\News;
use app\models\NewsCategory;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\View;

/** @var $model News */
/** @var $this View */

/** @var News[] $allNews */
$allNews = News::find()->where(["news_category_id" => NewsCategory::NEWS_ARTICLE])->orderBy(['created_at' => SORT_DESC])->limit(9)->all();
?>
    <style>
        .height-img {
            height: 382px;
            width: 100%;
            object-fit: cover;
            margin-right: -30px;
        }

        .box-button-na {
            background-color: #333;
            color: #ddd;
            width: 100%;
            float: left;
        }

        .box-text-na {
            float: left;
            margin: 5px 0px 5px 15px;
            background-color: #333;
        }

        .box-button-na:hover {
            color: white;
        }

        .box-text-na:hover {
            color: white;
        }

        .box-b-share {
            float: right;
            border-radius: 0px;
            border-left: 1px solid #ddd;
            padding: 5px 10px 5px 10px;
        }

        .b-share {
            font-size: 20px;
            float: right;
            background-color: transparent;
            text-align: center;
            color: #ddd;
            text-decoration: none;
            display: inline-block;
            border: none;
        }

        .box-na2 {
            margin: 30px -5px 0px 0px;
        }

        .box-image-na {
        }

        .image-na {
            width: 100%;
            height: 250px;
            object-fit: cover;
        }

        .h-mn {
            margin: -3px 0px 17px 0px;
            height: 36px;
            color: #333;
            border-bottom: 1px solid #ddd;
        }

        .fDIV {
            margin: 0;
            position: absolute;
            top: 50%;
            -ms-transform: translateY(-50%);
            transform: translateY(-50%);
        }

        .box-featured-image {
            height: 381px;
            width: 100%;
            object-fit: cover;
        }
        .firstcontentevents{
            height: 145px;
        }
    @media only screen and (max-width: 1180px) {
        .firstcontentevents{
            height: 140px;
        }
    }
    @media only screen and (max-width: 441px) {
        .firstcontentevents{
            height: 155px;
        }
    }
    @media only screen and (max-width: 329px) {
        .firstcontentevents{
            height: 158px;
        }
    }
    </style>
    <div class="row h-mn konten-news kontens"><h3> <?= app\models\Language::t("app", "Latest News & Events") ?> </h3></div>

<?php
if (count($allNews) > 0) {
    $firstNews = $allNews[0];
    $firstcontent = $firstNews->getContent();
    ?>

    <div class="row">
        <div class="col-md-12">
            <div class='box-image-na'>
                <a href="<?= Url::to(["/news/" . $firstNews->slug]) ?>" class="box-button-na">
                    <img src='<?= Url::to(Photo::get($firstNews->thumbnail_url, 'news')) ?>' class='img-fluid'>
                </a>
            </div>
            <div class='box-menu-na2 firstcontentevents'>
                <a href="<?= Url::to(["/news/" . $firstNews->slug]) ?>">
                    <h5 style='color: #fff;'><?= $firstNews->getTitle() ?></h5>
                </a>
                <?php
                $firstcontent = $firstNews->getContent();
                $firstcontent = strip_tags($firstcontent);

                if (strlen($firstcontent) > 200) {
                    echo substr($firstcontent, 0, 600) . " ...";
                } else {
                    echo $firstcontent;
                }
                ?>
            </div>
            <a href="<?= Url::to(["/news/" . $firstNews->slug]) ?>" class="box-button-na">
                <div class='box-text-na'><?= app\models\Language::t("app", "Read More") ?> >></div>
            </a>
        </div>
    </div>
    <div style="height: 20px"></div>
    <br/>

    <div class="row" id="news-events-detail"></div>

    <?= Html::a("<i class='fas fa-sync'></i> " . (Language::getActive() == Language::INDONESIA ? "Tampilkan Lebih Banyak" : "Load More"), "#", ["class" => "load-more"]); ?>

    <?php
    $this->registerJs('
var currentPage = 1;

function refreshSearching(page){
    currentPage = page;
    
    $.ajax({
        url:"' . Url::to(["/news/news-events-detail"]) . '",
        type: "GET",
        data: {
            page : page
        },
        success:function(data){
            if(page == 1){
                $("#news-events-detail").html(data);
            }else{
                //$(".load-more").remove();
                $("#news-events-detail").append(data);
            }
            
            $(".venobox").venobox();
        }
    });
}

$(document).on("click", ".load-more", function(){
    refreshSearching(currentPage + 1);
    return false;
}); 

refreshSearching(1);

$([document.documentElement, document.body]).animate({
    scrollTop: $(".kontens h3:eq(0)").offset().top - 20
}, 2000);

');
}