<?php

use app\models\Media;
use yii\helpers\Html;
use app\models\News;
use app\models\NewsCategory;
use yii\helpers\Url;

$perPage = 8;

$offset = (($page - 1) * $perPage) + 1;

/** @var News[] $allNews */
$allNews = News::find()->where(["news_category_id" => NewsCategory::NEWS_ARTICLE])->orderBy(['created_at' => SORT_DESC])->offset($offset)->limit($perPage)->all();
foreach ($allNews as $news) {
    ?>
<style>
    .content-boxnews{
        height: 170px;
    }
@media only screen and (max-width: 1182px) {
    .content-boxnews{
        height: 150px;
    }
}
@media only screen and (max-width: 972px) {
    .content-boxnews{
        height: 153px;
    }
}
@media only screen and (max-width: 480px) {
    .content-boxnews{
        height: 191px;
    }
}
@media only screen and (max-width: 437px) {
    .content-boxnews{
        height: 187px;
    }
}
</style>
    <div class="col-6 col-md-6 col-lg-4 col-xl-3">
        <a href='<?= Url::to(["/news/" . $news->slug]) ?>' class="news-box">
            <img src="<?= \app\components\Photo::get($news->thumbnail_url, "news") ?>"
                 class="product-image">
            <div class='news-box-content-separator'></div>
            <div class='news-box-content'>
                <?php
                $judul = $news->getTitle();
                $judul = strip_tags($judul);
                $content = strip_tags($news->getShortContent());
//                if (strlen($judul) > 129) {
//                    $juduls = substr($judul, 0, 129) . " ...";
//                    $contents = "";
//                } else if (strlen($judul) > 86) {
//                    $juduls = $judul;
//                    $contents = substr($content, 0, 20) . " ...";
//                } else if (strlen($judul) > 79) {
//                    $juduls = $judul;
//                    $contents = substr($content, 0, 36) . " ...";
//                } else if (strlen($judul) > 63) {
//                    $juduls = $judul;
//                    $contents = substr($content, 0, 62) . " ...";
//                } else if (strlen($judul) > 51) {
//                    $juduls = $judul;
//                    $contents = substr($content, 0, 86) . " ...";
//                } else if (strlen($judul) > 39) {
//                    $juduls = $judul;
//                    $contents = substr($content, 0, 100) . " ...";
//                } else if (strlen($judul) > 25) {
//                    $juduls = $judul;
//                    $contents = substr($content, 0, 139) . " ...";
//                } else {
//                    $juduls = $judul;
//                    $contents = substr($content, 0, 160) . " ...";
//                }
                ?>
                <h5 style='color: #fff;'><?= $judul ?></h5>
                <div class="description"><?= $content ?></div>
            </div>
            <div class='news-box-content-separator'></div>
            <div class='box-button-na'>
                <div class='box-text-na'>
                    <?= app\models\Language::t("app", "Read More") ?> &raquo;
                </div>
            </div>
        </a>
        <br>
        <br>
        <br>
        <br>
    </div>
    <?php
}

$showLoadMore = count($allNews) == $perPage ? true : false;

if ($showLoadMore) {
    echo "<script>$('.load-more').show();</script>";
} else {
    echo "<script>$('.load-more').hide();</script>";
}
?>