<?php

use app\models\Language;
use app\models\PageSliderDetail;
use yii\helpers\Url;
use yii\web\View;
use app\components\Photo;

/** @var $this View */

$sliders = PageSliderDetail::find()->where(["page_slider_id" => $id])->orderBy("`order` ASC")->all();
?>
<style>
    .carousel-caption {
        /*bottom: 40px !important;*/
        bottom: 0 !important;
        width: 100%;
        left: 0;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        padding: 0 15%;
    }
    .header-slider{
        margin-bottom: 15px;
    }
    @media only screen and (max-width: 750px) {
        .header-slider {
            margin-bottom: 6px !important;
        }
    }
</style>
<div class="bd-example">
    <div id="platinum_slider" class="carousel slide" data-ride="carousel">
        <ol class="carousel-indicators">
            <?php
            $no = 0;
            /** @var PageSliderDetail $slider */
            foreach ($sliders as $slider) {
                ?>
                <li data-target="#platinum_slider" data-slide-to="<?= $no ?>"
                    class="<?= $no == 0 ? "active" : "" ?>"></li>
                <?php
                $no++;
            }
            ?>
        </ol>
        <div class="carousel-inner">
            <?php
            $no = 0;
            /** @var PageSliderDetail $slider */
            foreach ($sliders as $slider) {
                ?>
                <div class="carousel-item <?= $no == 0 ? "active" : "" ?>">
                    <?= $slider->link_url ? "<a target='_blank' href='{$slider->getLink()}'>" : ""; ?>
                    <img src="<?= Photo::get($slider->image_path, 'slider') ?>" class="d-block" style="width: 100%;" >
                    <?php if($slider->status == 1) { ?>
                    <div class="carousel-caption">
                        <?php
                        if ($slider->description == "") { ?>
                            <div class=''>
                                <h4><?= Language::getActive() == Language::ENGLISH ? $slider->title : $slider->title_indo ?></h4>
                                <p style='font-size: 16px;'><?= Language::getActive() == Language::ENGLISH ? $slider->description : $slider->description_indo ?></p>
                            </div>
                            <?php

                        } else { ?>
                            <div class="bg-wrapper">
                                <p class="header-slider"><?= Language::getActive() == Language::ENGLISH ? $slider->title : $slider->title_indo ?></p>
                                <p style="font-size: 15px;" class="textslider"><?= Language::getActive() == Language::ENGLISH ? $slider->description : $slider->description_indo ?></p>
                            </div>
                        <?php } ?>
                    </div>
                    <?php } ?>
                    <?= $slider->link_url ? "</a>" : ""; ?>
                </div>
                <?php
                $no++;
            }
            ?>
        </div>
        <a class="carousel-control-prev" href="#platinum_slider" role="button" data-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="sr-only">Previous</span>
        </a>
        <a class="carousel-control-next" href="#platinum_slider" role="button" data-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="sr-only">Next</span>
        </a>
    </div>
</div>
