<?php
/**
 * Created by PhpStorm.
 * User: feb
 * Date: 5/12/19
 * Time: 9:37 PM
 */

use app\models\News;
use app\models\NewsCategory;
use yii\helpers\Html;
use yii\helpers\Url;

?>

<style>
    .carousel-btn {
        color: #fff;
        padding: 10px;
        background: #00000072;
        top: 92px;
        position: relative;
    }

    .black-box-na {
        background: transparent;
        border: 0px;
        color: #fff;
        padding: 3px;
        display: flex;
        justify-content: center;
        align-items: center;
        margin-right: 5px;
        border-radius: 5px;
        margin-top: 5px;
    }

    .black-box-na:hover {
        text-decoration: none;
        color: #fff;
    }

    .black-box-na i {
        font-size: 24px;
    }

    .box-button-na {
        margin-bottom: 20px;
    }

    .share-box-na {
        background-color: #aaa;
        position: absolute;
        box-shadow: 1px 1px #444;
        margin-top: 50px;
        z-index: 50;
    }


</style>
<h3></h3>
<div style="padding: 30px 0px;background: #f1f3f2">
    <?php
    /** @var News[] $allNews */
    $allNews = News::find()->orderBy("created_at DESC")->andWhere(["news_category_id" => [NewsCategory::NEWS_ARTICLE, NewsCategory::EVENT]])->limit(4)->all();
    ?>
    <div class="container">
        <h2 class="text-center section-title">
            <?= app\models\Language::t("app", "News") ?> &amp; <?= app\models\Language::t("app", "Events") ?>
            <br/>
            <?= Html::img(["/css/images/garis-hitam.png"], ["style" => "width:200px"]) ?>
        </h2>
        <div class="row">
            <div class="col-md-1 d-none d-sm-none d-md-none d-lg-block" style="text-align: right;">
                <a class="carousel-btn" href="#news_slider" role="button" data-slide="prev">
                    <i class="fa fa-chevron-left"></i>
                </a>
            </div>
            <div class="col-lg-10 col-sm-12">
                <div id="news_slider" class="carousel slide" data-ride="carousel">
                    <ol class="carousel-indicators border-min">
                        <?php
                        for ($i = 0; $i < 2; $i++) {
                            ?>
                            <li data-target="#news_slider" data-slide-to="<?= $i ?>"
                                class="<?= $i == 0 ? "active" : "" ?>"></li>
                            <?php
                        }
                        ?>
                    </ol>
                    <div class="carousel-inner">
                        <?php
                        $no = 0;
                        for ($i = 0; $i < 2; $i++) {
                            ?>
                            <div class="carousel-item <?= $i == 0 ? "active" : "" ?>">
                                <div class="row">
                                    <?php
                                    $id = 1;
                                    foreach ($allNews as $news) {
                                        ?>
                                        <div class="col-6 col-md-6 col-lg-3 col-xl-3">
                                            <a href='<?= Url::to(["/news/" . $news->slug]) ?>' class="news-box">
                                                <img src="<?= \app\components\Photo::get($news->thumbnail_url, "news") ?>"
                                                     class="product-image">

                                                <div class='news-box-content-separator'></div>

                                                <div class='news-box-content'>
                                                    <h5 style='color: #fff;'><?= $news->getTitle() ?></h5>
                                                    <div class="description"><?= $news->getShortContent() ?>...</div>
                                                </div>

                                                <div class='news-box-content-separator'></div>

                                                <div class='box-button-na'>
                                                    <div class='box-text-na'>
                                                        <?= app\models\Language::t("app", "Read More") ?> &raquo;
                                                    </div>
                                                </div>
                                            </a>
                                            <br>
                                            <br>
                                            <br>
                                            <br>
                                        </div>
                                        <?php
                                        $id++;
                                    }
                                    ?>
                                    <?php
                                    $this->registerJs('
                            $("#black-box-1").click(function(){
                                var data_id = $(this).attr("data_id");
                                $("#share-detail-"+data_id).toggle(100);
                                $(".ta-share-na-"+data_id).toggle(100);
                            });
                            
                        ');
                                    ?>
                                </div>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
            <div class="col-md-1 d-none d-sm-none d-md-none d-lg-block">
                <a class="carousel-btn" href="#news_slider" role="button" data-slide="next">
                    <i class="fa fa-chevron-right"></i>
                </a>
            </div>
        </div>
    </div>
</div>
