<?php

use app\models\Language;
use app\models\News;
use app\models\NewsCategory;
use yii\helpers\Html;
use yii\helpers\Url;

?>
<style>
    .sub-menu-nav {
        margin-top: -32px;
        border-radius: 0px;
        background-color: #000;
        opacity: 0.8;
        padding-bottom: 0px;
        top: 65px;
    }
    .bendera{
        width: 25px;
    }
    @media only screen
    and (max-width: 1090px) {
        .sub-menu-nav {
            margin-top: 0px;
        }
    }
    @media only screen
    and (max-width: 480px) {
        .bendera{
            width:20px;
        }
        .form-control-search{
            width: 100px;
            height: 18px;
            font-size: 12px;
        }
        .btn-primary-s{
            height: 18px;
            font-size: 10px;
            padding: 2px;
            margin-top: -1px;
        }
    }

    .last {
        border-bottom: 0px;
    }

    .navscroll {
        height: 0px;
        -webkit-transition: height 1s; /* For Safari 3.1 to 6.0 */
        transition: height 1s;
    }

    .navscroll2 {
        height: 105px;
    }

    input[type=search] {
        -webkit-appearance: textfield;
        -webkit-box-sizing: content-box;
        font-family: inherit;
        font-size: 100%;
    }
    input::-webkit-search-decoration,
    input::-webkit-search-cancel-button {
        display: none;
    }


    input[type=search] {
        background: #222 url("<?= Url::to(["css/images/search-white.png"]) ?>") no-repeat 7px center;
        border: none;
        padding: 1px 10px 4px 8px;
        width: 15px;
        border-radius: 0;
        -webkit-transition: all .5s;
        -moz-transition: all .5s;
        transition: all .5s;
        color: transparent;
    }
    input[type=search]:focus, input[type=search]:hover {
        background: #fff url("<?= Url::to(["css/images/search-black.png"]) ?>") no-repeat 7px center;
        width: 130px;
        border-color: #66CC75;

        -webkit-box-shadow: 0 0 5px rgba(109,207,246,.5);
        -moz-box-shadow: 0 0 5px rgba(109,207,246,.5);
        box-shadow: 0 0 5px rgba(109,207,246,.5);

        width: 130px;
        padding-left: 32px;
        color: #000;
        cursor: auto;
    }


    input:-moz-placeholder {
        color: #999;
    }
    input::-webkit-input-placeholder {
        color: #999;
    }


    #demo-2 input:-moz-placeholder {
        color: transparent;
    }
    #demo-2 input::-webkit-input-placeholder {
        color: transparent;
    }
</style>
<div style="background-color: #222; padding: 10px 0;">
    <div class="container">
        <div class="row justify-content-end">
            <div class="col-md-12">
                <form action="<?= Url::to(["/index/search"]) ?>" method="get" style="float: right" id="demo-2">
                    <input type="search" name="q" placeholder="<?= app\models\Language::t("app", "Search") ?>">
                </form>

                <?php
                $langId = Html::img("https://lipis.github.io/flag-icon-css/flags/4x3/id.svg", ["class"=> "bendera"]);
                $langEn = Html::img("https://lipis.github.io/flag-icon-css/flags/4x3/gb.svg", ["class"=> "bendera"]);
                ?>

                <div class="box-search" style="margin-right: 11px">
                    <?= Html::a($langId . "", ["site/switch-language", "lang" => Language::INDONESIA]) ?>
                    |
                    <?= Html::a($langEn . "", ["site/switch-language", "lang" => Language::ENGLISH]) ?>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="navigationbar" class="navbar navbar-expand-xl navbar-dark sticky-top bg-header-dark" style="background-color: rgba(0, 0, 0, 0.9) !important;">
    <div class="container">
        <a class="navbar-brand" href="<?= Url::to(["/"]) ?>">
            <?php
            $merk = @$_GET['merk'];
            $controllerId = Yii::$app->controller->id;
            $actionid = Yii::$app->controller->action->id;

            if ($controllerId == "product" && $actionid == "platinum-ceramics" || $merk == "platinum") {
                echo Html::img(['/css/images/logo-5.png'], [
                    "style" => "width:200px"
                ]);
            } else if ($controllerId == "product" && $actionid == "asia-tile" || $merk == "asiatile") {
                echo Html::img(['/css/images/logo-4-b.png'], [
                    "style" => "width:200px"
                ]);
            } else {
                echo Html::img(['/css/images/logo-6.png'], [
                    "style" => "width:200px"
                ]);
            }
            ?>
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarsExample07"
                aria-controls="navbarsExample07" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse justify-content-end" id="navbarsExample07" style="margin-right: -25px;">
            <ul class="navbar-nav">
                <?php

                $subMenus = [];
                /** @var News $news */
                foreach (News::find()->where(["news_category_id" => NewsCategory::OUR_COMPANY])->all() as $news) {
                    $subMenus[] = [$news->getTitle(), "our-company", $news->slug];
                }

                if (Language::getActive() == Language::INDONESIA) {
                    $subMenus[] = ["Karir", "career", "index"];

                    $menus = [
                        ["Beranda", "index", ""],
                        ["Produk", "product", "", [
                            ["Platinum Ceramics", "product", "platinum-ceramics"],
                            ["Asia Tile", "product", "asia-tile"],
                        ]],
                        ["Inspirasi", "inspiration", ""],
                        ["Perusahaan Kami", "our-company", "", $subMenus],
                        ["Berita & Acara", "news", "", [
                            ["Berita & Acara", "news", "index?news=news-events"],
                            ["Media", "news", "index?news=media"],
                            ["FAQ", "faq", ""],
                        ]],
                        ["Unduh Katalog", "download", ""],
                        ["Hubungi Kami", "contact", ""],
                    ];
                } else {
                    $subMenus[] = ["Career", "career", "index"];

                    $menus = [
                        ["Home", "index", ""],
                        ["Product", "product", "", [
                            ["Platinum Ceramics", "product", "platinum-ceramics"],
                            ["Asia Tile", "product", "asia-tile"],
                        ]],
                        ["Inspirations", "inspiration", ""],
                        ["Our Company", "our-company", "", $subMenus],
                        ["News & Events", "news", "", [
                            ["News & Events", "news", "index?news=news-events"],
                            ["Media", "news", "index?news=media"],
                            ["FAQ", "faq", ""],
                        ]],
                        ["Download", "download", ""],
                        ["Contact", "contact", ""],
                    ];
                }


                foreach ($menus as $menu) {
                    $hasChild = isset($menu[3]);
                    ?>
                    <li class="nav-item <?= $hasChild ? "dropdown" : "" ?> <?= Yii::$app->controller->id == $menu[1] ? "active" : "" ?>">
                        <?php
                        if ($hasChild) {
                            echo Html::a($menu[0], ["/" . $menu[1]], [
                                "class" => "nav-link dropdown-toggle",
                                "data-toggle" => "dropdown",
                                "aria-haspopup" => "true",
                                "aria-expanded" => "false",
                            ]);
                            echo "<div class='dropdown-menu sub-menu-nav'>";
                            foreach ($menu[3] as $menu2) {
                                echo Html::a($menu2[0], ["/" . $menu2[1] . "/" . $menu2[2]], ["class" => "dropdown-item"]);
                            }
                            echo "</div>";
                        } else {
                            echo Html::a($menu[0], ["/" . $menu[1] . "/" . $menu[2]], ["class" => "nav-link"]);
                        }
                        ?>
                    </li>
                    <?php
                }
                ?>
            </ul>
        </div>
    </div>
</div>
<script>
    var prevScrollpos = window.pageYOffset;
    var navs = document.getElementById("navigationbar");
    window.onscroll = function () {
        var currentScrollPos = window.pageYOffset;
        if (prevScrollpos > currentScrollPos) {
            navs.style.top = "0px";
            //navs.classList.add("navscroll2");
        } else {
            navs.style.top = "-105px";
            //navs.classList.add("navscroll");
        }
        prevScrollpos = currentScrollPos;
        if (document.body.scrollTop > 500 || document.documentElement.scrollTop > 500) {
            document.getElementById("myBtn").style.display = "block";
        } else {
            document.getElementById("myBtn").style.display = "none";
        }
    }

    // When the user clicks on the button, scroll to the top of the document
    function topFunction() {
        document.body.scrollTop = 0;
        document.documentElement.scrollTop = 0;
    }
</script>
