<?php

use app\models\Language;
use yii\helpers\Html;
use yii\helpers\Url;
use app\models\Setting;

?>
<style>
    h3 {
        font-size: 1.4rem;
    }

    hr {
        display: block;
        height: 1px;
        border: 0;
        border-top: 1px solid #ccc;
        margin: 1em 0;
        padding: 0;
    }

    .img-footer {
        width: 100px;
    }

    .f_href_hr {
        color: #fff;
        padding: 10px 0px;
        display: block;
        border-bottom: 1px solid #fff;
    }

    .f_href_hr:hover {
        text-decoration: none;
        color: #fff;
        background: #999;
        padding-left: 10px;
    }

    .text-bottom {
        color: #999;
        font-size: 13px;
        margin-bottom: 15px;
    }

    .text-bottom a {
        font-size: 13px !important;
        text-decoration: underline;
        color: #999;
        padding-left: 7px;
        padding-right: 7px;
    }

    hr {
        font-color: #ddd;
    }

    .box-font {
        float: left;
        width: 35px;
        height: 35px;
        padding-top: 2px;
        padding-left: 10px;
        margin: 1px;
        color: #fff;
        font-size: 20px;
    }

    address {
        font-size: 12px;
        margin-top: 15px;
    }

    .social-media {
        font-size: 12px;
    }

    .spacer {
        height: 20px;
        display: block;
        clear: both;
    }

    .tel {
        color: #fff
    }
    .tel:hover{
        color: #fff;
    }
</style>
<div style="background-color: #a8a8a8;color: #fff;padding: 30px 0">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-lg-6">
                <h3 class="font-weight-bold"><?= app\models\Language::t("app", "Navigation") ?> :</h3>

                <?php
                $menus1 = [
                    ["index", "Home", "Beranda"],
                    ["product/platinum-ceramics", "Platinum Ceramics", "Platinum Ceramics"],
                    ["product/asia-tile", "Asia Tile", "Asia Tile"],
                    ["inspiration", "Inspirations", "Inspirasi"],
                    ["our-company/about-us", "About Us", "Tentang Kami"],
                ];

                $menus2 = [
                    ["news", "News", "Berita"],
                    ["contact", "Contact", "Hubungi Kami"],
                    ["career", "Career", "Karir"],
                    ["download", "Downloads", "Unduhan"],
                    ["faq", "FAQ", "FAQ"],
                ];

                $lang = Language::getActive();
                ?>

                <div class="row">
                    <div class="col-md-6">
                        <?php
                        foreach ($menus1 as $item) {
                            echo Html::a($lang == Language::INDONESIA ? $item[2] : $item[1], ["/" . $item[0]], ["class" => "f_href_hr"]);
                        }
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        foreach ($menus2 as $item) {
                            echo Html::a($lang == Language::INDONESIA ? $item[2] : $item[1], ["/" . $item[0]], ["class" => "f_href_hr"]);
                        }
                        ?>
                    </div>
                </div>

                <div class="spacer"></div>
            </div>
            <div class="col-md-12 col-lg-6">
                <div class="row">
                    <div class="col-md-6">
                        <h3 class="font-weight-bold"><?= app\models\Language::t("app", "Head Office") ?> :</h3>

                        <b><?= app\models\Language::t("app", "PT PLATINUM CERAMICS INDUSTRY") ?></b>
                        <br/>
                        <address>
                            Jl. Panglima Sudirman 23 - 25<br/>
                            Surabaya, Jawa Timur 60271<br/>
                            <?= app\models\Language::t("app", "Phone/WA") ?> : <a class="tel" href="tel:0315312358">(031) 5312358</a> (<?= app\models\Language::t("app", "Hunting") ?>)<br/>
                            Fax : <a class="tel" href="tel:0315312362">(031) 5312362</a> (<?= app\models\Language::t("app", "Corporate") ?>)<br/><br/>
                        </address>
                    </div>
                    <div class="col-md-6">
                        <h3 class="font-weight-bold"><?= app\models\Language::t("app", "Social Media") ?> :</h3>

                        <div class="social-media">
                            <?= app\models\Language::t("app", "Follow us and get in touch with us on our social media to get updates on our products and latest inspirations.") ?>
                        </div>

                        <br/>

                        <?= Html::a("<i class=\"fab fa-facebook-f\"></i>", Setting::getValue("FACEBOOK_LINK") , ["class" => "icon-socmed", "target" => "_blank"]) ?>
                        <?= Html::a("<i class=\"fab fa-twitter \"></i>", Setting::getValue("TWITTER_LINK") , ["class" => "icon-socmed", "target" => "_blank"]) ?>
                        <?= Html::a("<i class=\"fab fa-instagram \"></i>", Setting::getValue("INSTAGRAM_LINK"), ["class" => "icon-socmed", "target" => "_blank"]) ?>
                        <?= Html::a("<i class=\"fab fa-linkedin \"></i>", Setting::getValue("LINKEDIN_LINK"), ["class" => "icon-socmed", "target" => "_blank"]) ?>
                        <?= Html::a("<i class=\"fab fa-whatsapp \"></i>", Setting::getValue("WHATSAPP_LINK")."?text=".urlencode(Language::getActive()==Language::ENGLISH ? "Hi, I would like to know more about Platinum Ceramics!" : "Halo, Saya ingin tahu lebih banyak tentang Platinum Ceramics!"), ["class" => "icon-socmed", "target" => "_blank"]) ?>

                        <div class="spacer"></div>
                    </div>
                    <div class="col-md-12">

                        <div class="row">
                            <div class="col-md-6 my-auto">
                                <h3 class="font-weight-bold"><?= app\models\Language::t("app", "Customer Hotline") ?> :</h3>
                            </div>
                            <div class="col-md-6">
                                <?= Html::a("<i class=\"fa fa-phone fa-rotate-90\"></i>", "tel:+6231-547-7576", ["class" => "icon-socmed"]) ?>
                                <a class="tel" style="font-size: 18px;" href="tel:+62315477576">+6231 547 7576</a>
                                <br>
                                (<?= app\models\Language::t("app", "within working hours") ?>)<br/>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="footer-div" style="padding: 30px 0">
    <div class="container text-center">
        <h3><?= app\models\Language::t("app", "Explore Us") ?> :</h3>
        <br />
        <div class="row">
            <div class="col-md-2"></div>
            <div class="col-6 col-md-2">
                <a href="<?= Url::to(["/product/platinum-ceramics"]) ?>" target="blank">
                    <?= Html::img(["/css/images/logo-3.png"], ["class" => "img-fluid"]) ?>
                </a>
            </div>
            <div class="col-6 col-md-2">
                <a href="<?= Url::to(["/product/asia-tile"]) ?>" target="blank">
                    <?= Html::img(["/css/images/logo-4.png"], ["class" => "img-fluid"]) ?>
                </a>
            </div>
            <div class="col-6 col-md-2">
                <a href="https://www.titaniumgranite.com/?brand=Infiniti" target="blank">
                    <?= Html::img(["/css/images/logo-2.png"], ["class" => "img-fluid"]) ?>
                </a>
            </div>
            <div class="col-6 col-md-2">
                <a href="https://www.titaniumgranite.com/?brand=Titanium" target="blank">
                    <?= Html::img(["/css/images/logo-1.png"], ["class" => "img-fluid"]) ?>
                </a>
            </div>
        </div>
        <br />

        <div class="row">
            <div class="col-12 col-md-6 text-center text-md-left text-bottom">
                Copyrights &copy; <?= date("Y") ?> <?= app\models\Language::t("app", "Platinum Ceramics Industry All Right Reserved") ?>
            </div>
            <div class="col-12 col-md-6 text-center text-md-right text-bottom">
                <?php
                $menuFooter = [
                    ["sitemap", "Sitemap", "Peta Situs"],
                    ["page/disclaimer", "Disclaimer", "Disclaimer"],
                    ["page/cookies-and-privacy-policy", "Cookies & Privacy Policy", "Kebijakan Cookies & Privasi"],
                    ["page/term-of-use", "Term of Use", "Kebijakan Penggunaan"],
                ];

                $output = [];

                foreach ($menuFooter as $item) {
                    $output[] = Html::a(Language::getActive() == Language::INDONESIA ? $item[2] : $item[1], ["/" . $item[0]], ["class" => "f_href"]);
                }

                echo implode(" | ", $output);
                ?>

            </div>
        </div>
    </div>
</div>
