<?php

use app\models\PopupInfo;
use yii\helpers\Html;
use yii\web\View;

/** @var PopupInfo $popup */
$popup = PopupInfo::find()->orderBy("id DESC")->one();

/** @var $this View */
?>
    <style>
        #btn-popup-info {
            background: <?= $popup->circle_color ?>;
            border: none;
            width: 58px;
            height: 58px;
            position: fixed;
            bottom: 20px;
            left: 30px;
            box-shadow: 0px 4px 8px #0000006b;
            border-radius: 50px;
            padding: 8px;
            margin: 0px;
            cursor: pointer;
            opacity: 0.7;
        }

        #btn-popup-info img {
            width: 100%;
        }

        #btn-popup-info:hover {
            opacity: 1;
        }

        #div-popup-info {
            background: url("<?= $popup->background_url ?>") no-repeat center center fixed;
            -webkit-background-size: cover;
            -moz-background-size: cover;
            -o-background-size: cover;
            background-size: cover;
            width: 300px;
            height: auto;
            position: fixed;
            bottom: 15px;
            left: 15px;
            z-index: 9999;
            box-shadow: 0px 0px 4px #0000009c;
            border-radius: 3px;
        }

        #div-popup-info #title {
            background: #0000003b;
            color: #fff;
            margin: 9px;
            padding: 9px;
            font-size: 18px;
        }

        #div-popup-info #content {
            background: #0000003b;
            color: #fff;
            margin: 9px;
            padding: 9px;
            font-size: 18px;
        }

        #div-popup-info #content img {
            max-width: 264px;
            height: auto !important;
        }

        #div-popup-info #button {
            padding: 0px 10px 10px;
        }

        #div-popup-info .close{
            position: absolute;
            color: #000;
            right: -5px;
            top: -8px;
            background: #fff;
            width: 30px;
            height: 30px;
            opacity: 1;
            display: flex;
            justify-content: center;
            align-items: center;
            border-radius: 15px;
            box-shadow: 0px 0px 7px #0009;
        }

        /* Smartphones (portrait and landscape) ----------- */
        @media only screen
        and (max-device-width : 480px) {
            /* Styles */
        }
    </style>
    <button id="btn-popup-info">
        <?= Html::img($popup->icon_url) ?>
        <p id="scroll-info" style="position: fixed;bottom: 200px;"></p>
    </button>

    <div id="div-popup-info" style="display: none;">
        <a href="#" class="close">
            <i class="fa fa-times"></i>
        </a>
        <div id="title"><?= $popup->title ?></div>
        <div id="content"><center><?= $popup->content ?></center></div>
        <div id="button"><?= ($popup->cta_label && $popup->cta_url) ? Html::a($popup->cta_label, $popup->cta_url, ["class" => "btn btn-success btn-block", "target"=>"_blank"]) : "" ?></div>
    </div>

<?php $this->registerJs('

$("#btn-popup-info").click(function(){
    $("#div-popup-info").show(500);
    Cookies.set("status-div-open", "open");
    return false;
});

$("#div-popup-info .close").click(function(){
    $("#div-popup-info").hide(500);
    Cookies.set("status-div-open", "close");
    return false;
});

var status = Cookies.get("status-div-open");
if(status == null || status == "open"){
    $("#div-popup-info").show(500);
    Cookies.set("status-div-open", "open");
}

');
