<?php

use app\components\Photo;
use app\components\Tanggal;
use app\models\Career;
use app\models\Faq;
use app\models\Inspiration;
use app\models\Language;
use app\models\News;
use app\models\ProductColor;
use app\models\SettingPeta;
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = Language::t("app", "Search") . " : " . $q;
?>

<style>
    .new-search-text {
        color: #999;
    }

    .title-page {
        padding-top: 1px;
        padding-bottom: 10px;
    }

    .title-page h1 {
        font-weight: bold;
    }

    h3 {
        padding-bottom: 15px;
    }

    .text-news-result {
        font-size: 14px;
        font-weight: bold;
        color: #000;
        padding-bottom: 10px;
        display: block;
    }
</style>

<div style="padding: 30px 0 20px;">
    <div class="container">
        <div class="row">
            <div class="col-12 title-page" style="color: #333;">
                <h1><?= Language::t("app", "Search") ?> : <?= $q ?></h1>
            </div>
        </div>
    </div>
</div>

<div class="container">
    <hr style="margin: 0px"/>
</div>

<div style="padding-top: 20px; padding-bottom: 20px">
    <div class="container">
        <?php
        $existAll = false;
        $products = ProductColor::find()
            ->joinWith("product")
            ->joinWith(["productColorSuitables" => function ($q) {
                $q->joinWith("suitable");
            }])
            ->where([
                "or",
                ["like", "product_color.color", $q],
                ["like", "product.name", $q],
                ["like", "product.look", $q],
                ["like", "suitable.nama_indonesia", $q],
                ["like", "suitable.nama_english", $q],
            ])->limit(100)->all();

        if (count($products) > 0) {
            $existAll = true;
            ?>
            <h3><?= Language::t("app", "Products") ?></h3>

            <div class="row">
                <?php


                /** @var ProductColor $result */
                foreach ($products as $result) {
                    $img = $result->image_path;
                    $product = $result->product;
                    if ($img == "") {
                        if ($product->brand == "PLATINUM") {
                            $img = "default.png";
                        } else {
                            $img = "default-as.png";
                        }
                    }
                    $id = $result->id;
                    $bg = $product->look == "MATT" ? "black" : "white";

                    ?>
                    <div class="col-6 col-md-6 col-lg-3 col-xl-2">
                        <a href="<?= $result->getUrl() ?>">
                            <div class="product-badge">
                                <span class="label-<?= $bg ?>"><?= $product->dimension ?></span>
                                <span class="label-<?= $bg ?>"><?= $product->look == "MATT" ? "M" : "G" ?></span>
                            </div>
                            <?= Html::img(Photo::get($img, "product"), ["class" => "product-image"]) ?>
                            <div class="product-description">
                                <h1><?= $product->name ?></h1>
                                <p><?= $result->color ?></p>
                            </div>
                        </a>
                    </div>
                    <?php
                }
                ?>
            </div>

            <hr/>

            <?php
        }
        $inspirations = Inspiration::find()
            ->joinWith("inspirationKategori")
            ->where([
                "or",
                ["like", "inspiration.title", $q],
                ["like", "inspiration.detail", $q],
                ["like", "inspiration.detail_indo", $q],
                ["like", "inspiration_kategori.nama_indonesia", $q],
                ["like", "inspiration_kategori.nama_english", $q],
            ])->limit(100)->all();
        if (count($inspirations) > 0) {
            $existAll = true;
            ?>
            <h3><?= Language::t("app", "Inspirations") ?></h3>

            <div class="row">
                <?php

                /** @var Inspiration $result */
                foreach ($inspirations as $result) {
                    $img = $result->gambar;
                    ?>
                    <div class="col-6 col-md-6 col-lg-3 col-xl-2">
                        <a href="<?= $result->getUrl() ?>">
                            <?= Html::img(Photo::get($img, "inspiration"), ["class" => "product-image"]) ?>
                            <div class="product-description">
                                <h1><?= $result->title ?></h1>
                            </div>
                        </a>
                    </div>
                    <?php
                }
                ?>
            </div>

            <hr/>
            <?php
        }
        $news = News::find()
            ->where([
                "or",
                ["like", "news.title_indonesia", $q],
                ["like", "news.title_english", $q],
                ["like", "news.content_indonesia", $q],
                ["like", "news.content_english", $q],
            ])
            ->andWhere(["status" => 1])->limit(100)->all();
        if (count($news) > 0) {
            $existAll = true;
            ?>

            <h3><?= Language::t("app", "News & Articles") ?></h3>

            <div class="row">
                <?php

                /** @var News $result */
                foreach ($news as $result) {

                    ?>
                    <div class="col-12">
                        <a href="<?= $result->getUrl() ?>" class="text-news-result">
                            <div class="media" style="margin-bottom: 10px">
                                <img class="mr-3" src="<?= Url::to(Photo::get($result->thumbnail_url, "news")) ?>"
                                     style="width: 60px"
                                     alt="<?= $result->getTitle() ?>">
                                <div class="media-body">
                                    <h5 class="mt-0"><?= $result->getTitle() ?></h5>
                                    <?= Tanggal::toReadableDate($result->created_at, false ,true); ?>
                                </div>
                            </div>
                        </a>
                    </div>
                    <?php
                }
                ?>
            </div>

            <hr/>
            <?php
        }
        $careers = Career::find()
            ->where([
                "or",
                ["like", "job_title_indonesia", $q],
                ["like", "job_title_english", $q],
                ["like", "detail_indonesia", $q],
                ["like", "detail_english", $q],
            ])
            ->andWhere(["status" => 1])->limit(100)->all();
        if (count($careers) > 0) {
            $existAll = true;
            ?>
            <h3><?= Language::t("app", "Career") ?></h3>

            <div class="row">
                <?php

                /** @var Career $career */
                foreach ($careers as $career) {

                    ?>
                    <div class="col-12">
                        <a href="<?= Url::to(["career/detail", "id" => $career->id]) ?>" class="text-news-result">
                            <div class="media" style="margin-bottom: 10px">
                                <div class="media-body">
                                    <h5 class="mt-0"><?= $career->getJobTitle() ?></h5>
                                    <?= Tanggal::toReadableDate($career->created_at, false, true); ?>
                                </div>
                            </div>
                        </a>
                    </div>
                    <?php
                }
                ?>
            </div>

            <hr/>
            <?php
        }
        $settingPetas = SettingPeta::find()
            ->where([
                "or",
                ["like", "alamat", $q],
                ["like", "alamat_inggris", $q],
                ["like", "kota", $q],
                ["like", "jenis_kantor", $q],
            ])
            ->limit(100)->all();
        if (count($settingPetas) > 0) {
            $existAll = true;
            ?>
            <h3><?= Language::t("app", "Contact") ?></h3>

            <div class="row">
                <?php

                /** @var SettingPeta $settingPeta */
                foreach ($settingPetas as $settingPeta) {

                    ?>
                    <div class="col-12">
                        <a href="<?= Url::to(["/contact"]) ?>" class="text-news-result">
                            <div class="media" style="margin-bottom: 10px">
                                <div class="media-body">
                                    <h5 class="mt-0"><?= $settingPeta->jenis_kantor . " - " . $settingPeta->kota ?></h5>
                                    <?= $settingPeta->alamat ?>
                                </div>
                            </div>
                        </a>
                    </div>
                    <?php
                }
                ?>
            </div>

            <hr/>
            <?php
        }

        $pages = [
            ["faq", "FAQ", "FAQ", ["/faq"]],
            ["sitemap", "Sitemap", "Peta Situs", ["/sitemap"]],
        ];

        $exist = false;

        $outputPages = [];

        foreach ($pages as $page) {
            if (strpos($page[0], $q) !== false || strpos(strtolower($page[1]), $q) !== false || strpos(strtolower($page[2]), $q) !== false) {
                $exist = true;

                ob_start();
                ?>
                <div class="col-12">
                    <a href="<?= Url::to($page[3]) ?>" class="text-news-result">
                        <div class="media" style="margin-bottom: 10px">
                            <div class="media-body">
                                <h5 class="mt-0"><?= Language::getActive() == Language::ENGLISH ? $page[1] : $page[2] ?></h5>
                            </div>
                        </div>
                    </a>
                </div>
                <?php

                $outputPages[] = ob_get_clean();
            }
        }
        if (count($outputPages) > 0) {
            $existAll = true;
            ?>

            <h3><?= Language::t("app", "Other Pages") ?></h3>

            <div class="row">
                <?php
                echo implode(' ', $outputPages);
                if ($exist == false) {
                    ?>
                    <div class="col">
                        <?= Language::t("app", "Other Page Not Found"); ?>
                    </div>
                    <?php
                }
                ?>
            </div>

            <hr/>
            <?php
        }

        /** @var Faq[] $faqs */
        $faqs = Faq::find()->where([
            "or",
            ["like", "title_indonesia", $q],
            ["like", "title_english", $q],
            ["like", "content_indonesia", $q],
            ["like", "content_english", $q]
        ])->all();

        if (count($faqs) > 0) {
            $existAll = true;
            ?>
            <h3><?= Language::t("app", "FAQ") ?></h3>

            <div class="row">
                <?php


                foreach ($faqs as $faq) {
                    ?>
                    <div class="col-12">
                        <a href="<?= Url::to(["/faq"]) ?>" class="text-news-result">
                            <div class="media" style="margin-bottom: 10px">
                                <div class="media-body">
                                    <h5 class="mt-0"><?= Language::getActive() == Language::ENGLISH ? $faq->title_english : $faq->title_indonesia ?></h5>
                                </div>
                            </div>
                        </a>
                    </div>
                    <?php
                }
                ?>
            </div>
            <?php
        }

        if($existAll == false){
            ?>

            <?= Language::t("app", "Search Not Found.") ?>

        <?php
        }
        ?>
    </div>
</div>