<?php

//use app\components\Photo;
use app\models\Career;
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */
$this->title = "Career";
?>

<style>
    .link {
        color: #000;
        text-decoration: underline;
    }

    ul {
        padding-left: 13px;
    }

    ul li {
        float: none;
    }

    .table tr:first-child th, .table tr:first-child td {
        border-top: 0px;
    }
</style>

<?= $this->render('@app/views/career/header'); ?>
<div class="container" style="margin-top: 20px;">
    <div class="row">
        <div class="col">
            <div class="row">
                <div class="col">
                    <h3><?= app\models\Language::t("app", "CAREER") ?></h3>
                    <hr/>
                    <?= app\models\Language::t("app", "The Platinum Ceramics Industry workforce is highly skilled, highly experienced, and highly motivated. The environment within the company encourages contributions and ideas, empowering employees to apply their initiative to achieve continuous improvement in every aspect of the operation.") ?>
                    <br /><br />
                    <?= app\models\Language::t("app", "For job vacancy, please view our available listing. To apply, please send your recent CV and photograph to: career@platinumceramics.com") ?>
                    <br /><br />
                    <?= app\models\Language::t("app", "Only qualified candidates will be contacted.") ?>
                    <br /><br />
                    <b><?= app\models\Language::t("app", "“WE SET YOUR CAREER, WE CARE FOR YOUR FUTURE”") ?></b><br /><br /><br />
                </div>
            </div>
            <div class="row">
                <div class="col">
                    <h3><?= app\models\Language::t("app", "Latest Vacancy") ?></h3>
                    <hr/>
                </div>
            </div>
            <div class="row">
                <?php
                /** @var Career[] $careers */
                $careers = Career::find()->limit(2)->orderBy("id DESC")->all();
                foreach ($careers as $job) {
                }
                ?>
            </div>
            <div class="row">
                <div class="col">

                    <table class="table">
                        <?php
                        /** @var Career[] $listJob */
                        $query = Career::find();
                        if (isset($_GET['filter'])) {
                            $tanggal = $_GET['filter'];
                            $tahun = intval(date("Y", strtotime($tanggal)));
                            $bulan = intval(date("m", strtotime($tanggal)));

                            $query->where(["month(created_at)" => $bulan, "year(created_at)" => $tahun]);
                        }
                        $listJob = $query->orderBy("id DESC")->limit(10)->all();

                        foreach ($listJob as $job) {
                            ?>
                            <tr>
                                <td style="padding-left: 0px">
                                    <?= Html::a($job->getJobTitle(), ['detail', 'career' => $job->id], ["class" => "link"]) ?>
                                </td>
                                <td>
                                    <?= date("d/m/Y", strtotime($job->created_at)) ?>
                                </td>
                            </tr>
                            <?php
                        }

                        if(count($listJob) == 0){
                            ?>
                            <tr>
                                <td style="padding-left: 0px">
                                    <?= \app\models\Language::t("app", "Career Not Found"); ?>
                                </td>
                            </tr>
                            <?php
                        }
                        ?>
                    </table>


                </div>
            </div>
        </div>
        <div class="col-12 col-md-3" style="margin-bottom: 30px;">
            <h3><?= app\models\Language::t("app", "Archive"); ?></h3>

            <ul>
                <?php
                for ($i = 0; $i <= 12; $i++) {
                    $tanggal = strtotime("-" . $i . " month");

                    echo "<li>" . Html::a(date("M Y", $tanggal), ["index", "filter" => date("Y-m-01", $tanggal)], ["class" => "link"]) . "</li>";
                }
                ?>
            </ul>
        </div>
    </div>
</div>