<?php
use app\components\Photo;
use app\components\Tanggal;
use app\models\News;
use yii\helpers\Html;
use app\models\Language;
use yii\helpers\Url;
use yii\web\View;
?>
<style>
    .color-a{
        color: black;
    }
    .color-a:hover{
        color: #000;
    }
    .link {
        color: #000;
        text-decoration: underline;
    }

    ul {
        padding-left: 13px;
    }

    ul li {
        float: none;
    }

    .table tr:first-child th, .table tr:first-child td {
        border-top: 0px;
    }
</style>
<div style="padding: 30px 0">
    <div class="container">
        <div class="row h-mn konten-news">
            <h3></h3>
            <div class="col-md-8" style="text-align: justify">
                <?php
                /** @var Career[] $listJob */
                //echo $id;
                $filter = $_GET['filter'];
                $query = News::find()->where(["news_category_id" => 1]);
                if (isset($filter)) {
                        $tanggal = $filter;
                        $tahun = intval(date("Y", strtotime($tanggal)));
                        $bulan = intval(date("m", strtotime($tanggal)));

                        $query->where(["news_category_id" => 1, "month(created_at)" => $bulan, "year(created_at)" => $tahun]);
                    }
                    ?>
                <h3><?= app\models\Language::t("app", "Archive News & Events");?> <?= $filter; ?></h3>
                <br/>
                <table class="table">
                    <?php
                    $listNews = $query->orderBy("id DESC")->limit(10)->all();

                    foreach ($listNews as $inews) {
                        ?>
                        <tr>
                            <td style="padding-left: 0px">
                                <?= Html::a($inews->getTitle(), ['/news/'. $inews->slug], ["class" => "link"]) ?>
                            </td>
                            <td>
                                <?= date("d/m/Y", strtotime($inews->created_at)) ?>
                            </td>
                        </tr>
                        <?php
                    }

                    if(count($listNews) == 0){
                        ?>
                        <tr>
                            <td style="padding-left: 0px">
                                <?php
                                echo \app\models\Language::t("app", "News & Events Not Found");
                                ?>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </table><br /><br />
            </div>
            <div class="col-md-4">
                <div class="box-left">
                    <h4 style="margin-bottom: 27px">
                        <?= \app\models\Language::t("app", "Other News & Events"); ?>
                    </h4>
                    <?php
                    /** @var News[] $listBerita */
                    $listBerita = News::find()->where(["news_category_id" => 1])->orderBy("id DESC")->limit(4)->all();
                    foreach ($listBerita as $berita) {
                        ?>
                        <a href="<?= Url::to(["/news/" . $berita->slug]) ?>" class="color-a">
                            <div class="media" style="margin-bottom: 10px">
                                <img class="mr-3" src="<?= Url::to(Photo::get($berita->thumbnail_url, "news")) ?>"
                                     style="width: 60px"
                                     alt="<?= $berita->getTitle() ?>"/>
                                <div class="media-body">
                                    <h6 class="mt-0"><?= $berita->getTitle() ?></h6>
                                    <?php echo Tanggal::toReadableDate($berita->created_at, false ,true); ?>
                                </div>
                            </div>
                        </a>
                        <?php
                    }
                    ?>
                </div>
                <div class="box-left" style="margin-top: 50px;">
                    <h3><?= app\models\Language::t("app", "Archive"); ?></h3><br />
                    <ul>
                        <?php
                        for ($i = 0; $i <= 12; $i++) {
                            $tanggal = strtotime("-" . $i . " month");

                            echo "<li>" . Html::a(date("M Y", $tanggal), ["/archive", "filter" => date("Y-m-01", $tanggal)], ["class" => "link"]) . "</li>";
                        }
                        ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>