<?php

namespace app\models;

use app\models\base\News as BaseNews;
use yii\helpers\Url;

/**
 * This is the model class for table "news".
 */
class News extends BaseNews
{
    public function getTitle()
    {
        if (Language::getActive() == Language::INDONESIA) {
            return $this->title_indonesia;
        } else {
            return $this->title_english;
        }
    }

    public function getContent()
    {
        if (Language::getActive() == Language::INDONESIA) {
            return $this->content_indonesia;
        } else {
            return $this->content_english;
        }
    }

    public function getShortContent()
    {
        $content = "";
        if (Language::getActive() == Language::INDONESIA) {
            $content = $this->content_indonesia;
        } else {
            $content = $this->content_english;
        }

        $content = strip_tags($content);

        if (strlen($content) > 250) {
            $content = substr($content, 0, 250);
        }

        return $content;
    }

    public function getUrl(){
        if($this->news_category_id == 5){
            //our company
            return Url::to(["our-company/".$this->slug]);
        }else if($this->news_category_id == 4){
            //page bawah
            return Url::to(["page/".$this->slug]);
        }

        return Url::to(["news/".$this->slug]);
    }
}
