<?php

namespace app\controllers;

use app\models\News;
use yii\web\NotFoundHttpException;

class NewsController extends BaseController
{
    public function actionIndex($news = null)
    {
        return $this->render('index', [
            "type" => $news
        ]);
    }

    public function actionView($slug)
    {
        $news = News::find()->where(["slug" => $slug])->one();

        if($news) {
            return $this->render('view', [
                "model" => $news
            ]);
        }

        throw new NotFoundHttpException("Not Found #(404)", 404);
    }

    public function actionNewsEventsDetail($page = 1)
    {
        return $this->renderPartial('news-events-detail', [
            "page" => $page
        ]);
    }

    public function actionMediaDetail($page = 1)
    {
        return $this->renderPartial('media-detail', [
            "page" => $page
        ]);
    }
}
