<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

namespace app\assets;

use yii\web\AssetBundle;
use yii\web\JqueryAsset;

/**
 * Main application asset bundle.
 *
 * @author Qiang Xue <qiang.xue@gmail.com>
 * @since 2.0
 */
class AppAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web';
    public $css = [
        'css/style.css?v=0.0.6',
        'css/bootstrap.min.css',
        'fontawesome/css/all.min.css',
        'css/grid.css',
        'css/image-zoom.css',
        'https://fonts.googleapis.com/css?family=Krub:400,700',
        'https://fonts.googleapis.com/css?family=Noto+Serif+SC',
        'css/venobox.css',
        'css/cookieconsent.min.css',
    ];
    public $js = [
        'https://cdn.jsdelivr.net/npm/js-cookie@2/src/js.cookie.min.js',
        'https://maps.googleapis.com/maps/api/js?key=AIzaSyCaLTRspMDvX9TfZSXtDWCyxYoBIBAZPWA',
        'js/bootstrap.bundle.min.js',
        //'js/jquery.min.js',
        'js/cookieconsent.min.js',
        'js/xzoom.js',
        'js/image-zoom.js',
        'js/jquery.zoom.min.js', //orangnya minta model zoom langsung
        'js/hammer.js',
        'js/foundation.js',
        'js/venobox.min.js',
//        'https://cdnjs.cloudflare.com/ajax/libs/jquery.touchswipe/1.6.4/jquery.touchSwipe.min.js',
//        'https://cdnjs.cloudflare.com/ajax/libs/prefixfree/1.0.7/prefixfree.min.js',
        'https://cdnjs.cloudflare.com/ajax/libs/jquery.touchswipe/1.6.4/jquery.touchSwipe.min.js',
        'js/script.js?v=0.0.11',


/*
<link href="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" rel="stylesheet" id="bootstrap-css">
<script src="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery/2.2.4/jquery.min.js"></script>
<script src='https://code.jquery.com/jquery-2.1.1.js'></script>
<script src='https://unpkg.com/xzoom/dist/xzoom.min.js'></script>
<script src='https://hammerjs.github.io/dist/hammer.min.js'></script>
<script src='https://cdnjs.cloudflare.com/ajax/libs/foundation/6.3.1/js/foundation.min.js'></script>
*/
    ];
    public $depends = [
        'yii\web\YiiAsset',
        'yii\web\JqueryAsset',
        //'yii\bootstrap\BootstrapAsset',
    ];
}
