<?php

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use \dmstr\bootstrap\Tabs;
use backend\components\CKEditorWidget;

/**
 * @var yii\web\View $this
 * @var backend\models\News $model
 * @var yii\widgets\ActiveForm $form
 */

?>

<div class="box box-info">
    <div class="box-body">
        <?php $form = ActiveForm::begin([
                'id' => 'News',
                'layout' => 'horizontal',
                'enableClientValidation' => true,
                'errorSummaryCssClass' => 'error-summary alert alert-error'
            ]
        );
        ?>
        <?= $form->field($model, 'thumbnail_url')->widget(\backend\components\form\AreisUploader::className(), ["folder"=>"news"]) ?>

        <?= $form->field($model, 'created_at')->input('date', ['maxlength' => true]) ?>

        <?= $form->field($model, 'title_indonesia')->textInput(['maxlength' => true]) ?>

        <?= $form->field($model, 'title_english')->textInput(['maxlength' => true]) ?>

        <?= $form->field($model, 'news_category_id')->dropDownList(
            \yii\helpers\ArrayHelper::map(backend\models\NewsCategory::findActive(), 'id', 'title_indonesia'),
            ['prompt' => '(Pilih Kategori News)']
        ); ?>

        <div class="row">
            <div class="col-md-offset-3 col-md-6">
                <div class="alert alert-info fade in alert-dismissible">
                    Slug URL digunakan untuk SEO, kosongi jika ingin membuat slug secara otomatis.
                </div>
            </div>
        </div>

        <?= $form->field($model, 'slug')->textInput(['maxlength' => true]) ?>

        <?= $form->field($model, 'content_indonesia', ["wrapperOptions" => ["class" => "col-md-8"]])->widget(CKEditorWidget::className()); ?>

        <?= $form->field($model, 'content_english', ["wrapperOptions" => ["class" => "col-md-8"]])->widget(CKEditorWidget::className()); ?>


        <hr/>
        <?php echo $form->errorSummary($model); ?>
        <div class="row">
            <div class="col-md-offset-3 col-md-10">
                <?= Html::submitButton('<i class="fa fa-save"></i> Simpan', ['class' => 'btn btn-success']); ?>
                <?= Html::a('<i class="fa fa-chevron-left"></i> Kembali', ['index'], ['class' => 'btn btn-default']) ?>
            </div>
        </div>

        <?php ActiveForm::end(); ?>

    </div>
</div>

<?php $this->registerJs('

/*
CKEDITOR.replace("news-content_indonesia", {
    filebrowserImageUploadUrl: "' . \yii\helpers\Url::to(["uploader/upload-ckeditor"]) . '",
    enterMode: CKEDITOR.ENTER_BR,
    shiftEnterMode: CKEDITOR.ENTER_P,
        
});

CKEDITOR.replace("news-content_english", {
    filebrowserImageUploadUrl: "' . \yii\helpers\Url::to(["uploader/upload-ckeditor"]) . '",
    enterMode: CKEDITOR.ENTER_BR,
    shiftEnterMode: CKEDITOR.ENTER_P,
        
});
*/

') ?>