<?php

namespace backend\models\search;

use backend\models\News as NewsModel;
use yii\base\Model;
use yii\data\ActiveDataProvider;

/**
 * News represents the model behind the search form about `backend\models\News`.
 */
class NewsSearch extends NewsModel
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id'], 'integer'],
            [['title_indonesia', 'title_english', 'content_indonesia', 'content_english'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
// bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = NewsModel::find();//->orderBy("created_at DESC");

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if($query->orderBy == null){
            $query->orderBy("created_at DESC");
        }

        if (!$this->validate()) {
            // uncomment the following line if you do not want to any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
        ]);

        $query->andFilterWhere(['like', 'title_indonesia', $this->title_indonesia])
            ->andFilterWhere(['like', 'title_english', $this->title_english])
            ->andFilterWhere(['like', 'content_indonesia', $this->content_indonesia])
            ->andFilterWhere(['like', 'content_english', $this->content_english]);

        return $dataProvider;
    }
}