<?php
// This class was automatically generated by a giiant build task
// You should not change it manually as it will be overwritten on next build

namespace backend\models\base;

use Yii;

/**
 * This is the base-model class for table "news".
 *
 * @property integer $id
 * @property integer $news_category_id
 * @property string $title_indonesia
 * @property string $title_english
 * @property string $slug
 * @property string $thumbnail_url
 * @property string $content_indonesia
 * @property string $content_english
 * @property string $created_at
 * @property integer $created_by
 * @property string $updated_at
 * @property integer $updated_by
 * @property integer $status
 *
 * @property \backend\models\User $createdBy
 * @property \backend\models\User $updatedBy
 * @property \backend\models\NewsCategory $newsCategory
 * @property string $aliasModel
 */
abstract class News extends \yii\db\ActiveRecord
{



    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'news';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['news_category_id', 'created_at', 'created_by'], 'required'],
            [['news_category_id', 'created_by', 'updated_by', 'status'], 'integer'],
            [['content_indonesia', 'content_english'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
            [['title_indonesia', 'title_english', 'slug', 'thumbnail_url'], 'string', 'max' => 255],
            [['created_by'], 'exist', 'skipOnError' => true, 'targetClass' => \backend\models\User::className(), 'targetAttribute' => ['created_by' => 'id']],
            [['updated_by'], 'exist', 'skipOnError' => true, 'targetClass' => \backend\models\User::className(), 'targetAttribute' => ['updated_by' => 'id']],
            [['news_category_id'], 'exist', 'skipOnError' => true, 'targetClass' => \backend\models\NewsCategory::className(), 'targetAttribute' => ['news_category_id' => 'id']]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'news_category_id' => 'Kategori',
            'title_indonesia' => 'Judul Indonesia',
            'title_english' => 'Judul English',
            'slug' => 'Slug URL',
            'thumbnail_url' => 'Thumbnail Url',
            'content_indonesia' => 'Konten Indonesia',
            'content_english' => 'Konten English',
            'created_at' => 'Tanggal Pembuatan',
            'created_by' => 'Created By',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
            'status' => 'Status',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(\backend\models\User::className(), ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUpdatedBy()
    {
        return $this->hasOne(\backend\models\User::className(), ['id' => 'updated_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNewsCategory()
    {
        return $this->hasOne(\backend\models\NewsCategory::className(), ['id' => 'news_category_id']);
    }




}
