<?php

namespace backend\models;

use backend\models\base\News as BaseNews;
use common\components\Util;

/**
 * This is the model class for table "news".
 */
class News extends BaseNews
{
    public function beforeSave($insert)
    {
        if ($this->slug == null) {
            $this->slug = Util::slugify($this->title_english);
        }
        return true;
    }

    public function afterFind()
    {
        if($this->created_at){
            $this->created_at = date("Y-m-d", strtotime($this->created_at));
        }
    }
}
