<?php

namespace backend\controllers;

use backend\models\PageSlider;
use backend\models\PageSliderDetail;
use Gumlet\ImageResize;
use yii\web\HttpException;
use yii\web\UploadedFile;

class PageSliderDetailController extends BackendController
{
    /**
     * @var boolean whether to enable CSRF validation for the actions in this controller.
     * CSRF validation is enabled only when both this property and [[Request::enableCsrfValidation]] are true.
     */
    public $enableCsrfValidation = false;

    /**
     * @param $model PageSliderDetail
     * @throws \Gumlet\ImageResizeException
     * @throws \yii\base\Exception
     */
    public function updateImage($model)
    {
        $oldPhotoUrl = $model->image_path;
        $image = UploadedFile::getInstance($model, 'image_path');
        if ($image != NULL) {
            # store the source file name
            $model->image_path = $image->name;
            $arr = explode(".", $image->name);
            $extension = end($arr);

            # generate a unique file name
            $model->image_path = "slider-" . md5(date("Y_m_d_H_i_s_")) . "." . $extension;

            # the path to save file
            $path = \Yii::getAlias("@frontend_new/web/uploads/slider/") . $model->image_path;
            $image->saveAs($path);


            $image = new ImageResize($path);
            $image->crop(PageSlider::IMAGE_WIDTH, $model->slider_height, true);
            $image->save($path);
        } else {
            $model->image_path = $oldPhotoUrl;
        }
    }

    public function actionCreate($page_slider_id)
    {
        $model = new PageSliderDetail;
        $model->page_slider_id = $page_slider_id;

        if ($model->load($_POST)) {
            $this->updateImage($model);

            //get most big
            /** @var PageSliderDetail $big */
            $big = PageSliderDetail::find()->where(["page_slider_id" => $page_slider_id])->orderBy("`order` DESC")->one();

            $model->order = $big ? $big->order + 1 : 1;
            if ($model->save()) {
                return $this->redirect(['page-slider/update', 'id' => $page_slider_id]);
            }
        }

        return $this->render('create', ['model' => $model]);
    }


    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $page_slider_id = $model->page_slider_id;

        $oldImage = $model->image_path;
        if ($model->load($_POST)) {
            $this->updateImage($model);

            if($model->image_path == null){
                $model->image_path = $oldImage;
            }

            //get most big
            /** @var PageSliderDetail $big */
            $big = PageSliderDetail::find()->where(["page_slider_id" => $page_slider_id])->orderBy("`order` DESC")->one();

            //$model->order = $big ? $big->order + 1 : 1;
            if ($model->save()) {
                return $this->redirect(['page-slider/update', 'id' => $page_slider_id]);
            }
        }

        return $this->render('update', ['model' => $model]);
    }

    public function actionDelete($id)
    {
        $model = $this->findModel($id);
        $page_slider_id = $model->page_slider_id;
        $model->delete();

        return $this->redirect(['page-slider/update', 'id' => $page_slider_id]);
    }

    /**
     * @return PageSliderDetail the loaded model
     * @throws HttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = PageSliderDetail::findOne($id)) !== null) {
            return $model;
        } else {
            throw new HttpException(404, 'The requested page does not exist.');
        }
    }
}
