<?php
// This class was automatically generated by a giiant build task
// You should not change it manually as it will be overwritten on next build

namespace backend\models\base;

use Yii;

/**
 * This is the base-model class for table "career".
 *
 * @property integer $id
 * @property string $job_title_english
 * @property string $job_title_indonesia
 * @property string $detail_english
 * @property string $detail_indonesia
 * @property string $thumbnail_url
 * @property string $apply_url
 * @property string $created_at
 * @property integer $created_by
 * @property string $updated_at
 * @property integer $updated_by
 * @property integer $status
 *
 * @property \backend\models\User $createdBy
 * @property \backend\models\User $updatedBy
 * @property string $aliasModel
 */
abstract class Career extends \yii\db\ActiveRecord
{



    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'career';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['job_title_english', 'thumbnail_url', 'apply_url', 'created_at', 'created_by'], 'required'],
            [['detail_english', 'detail_indonesia'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
            [['created_by', 'updated_by', 'status'], 'integer'],
            [['job_title_english', 'job_title_indonesia'], 'string', 'max' => 50],
            [['thumbnail_url', 'apply_url'], 'string', 'max' => 255],
            [['created_by'], 'exist', 'skipOnError' => true, 'targetClass' => \backend\models\User::className(), 'targetAttribute' => ['created_by' => 'id']],
            [['updated_by'], 'exist', 'skipOnError' => true, 'targetClass' => \backend\models\User::className(), 'targetAttribute' => ['updated_by' => 'id']]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'job_title_english' => 'Job Title English',
            'job_title_indonesia' => 'Job Title Indonesia',
            'detail_english' => 'Detail English',
            'detail_indonesia' => 'Detail Indonesia',
            'thumbnail_url' => 'Thumbnail Url',
            'apply_url' => 'Apply Url',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
            'status' => 'Status',
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeHints()
    {
        return array_merge(parent::attributeHints(), [
            'thumbnail_url' => 'gambar thumbnail',
        ]);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(\backend\models\User::className(), ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUpdatedBy()
    {
        return $this->hasOne(\backend\models\User::className(), ['id' => 'updated_by']);
    }




}
