<?php

namespace app\controllers;

use app\models\Download;
use app\models\Language;
use app\models\SettingKatalog;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use yii\helpers\Url;
use Yii;

class DownloadController extends BaseController
{
    public function actionIndex()
    {
        Yii::$app->language = Language::getActive();

        $model = new Download();
        try {
            if ($model->load($_POST) && $model->save()) {
                return $this->redirect(['send-mail']);
                //return $this->redirect(['/index']);
            } elseif (!\Yii::$app->request->isPost) {
                $model->load($_GET);
            }
        } catch (\Exception $e) {
            $msg = (isset($e->errorInfo[2])) ? $e->errorInfo[2] : $e->getMessage();
            $model->addError('_exception', $msg);
        }
        return $this->render('index', ['model' => $model]);
    }

    public function actionSendMail()
    {
        /** @var SettingKatalog $download */
        $download = SettingKatalog::find()->orderBy("id DESC")->one();
        $file_download = $download->file_path;

        /** @var Download $contact */
        $contact = Download::find()->orderBy("id DESC")->one();
        $nama = $contact->full_name;
        $email = $contact->email;
        $phone = $contact->phone;
        $subject = "Your Catalogue Is Here";

        $body = $this->renderPartial('send-email', [
            'nama' => $nama,
            'download' => $download,
            'file_download' => $file_download,
            'contact' => $contact,
            'email' => $email,
            'phone' => $phone,
            'subject' => $subject,
        ]);

        Yii::$app->mailer->compose()
            ->setTo(Yii::$app->params["marketingEmail"])
            ->setFrom([Yii::$app->params["senderEmail"] => 'Platinum Ceramics Team'])
            ->setSubject($subject)
            ->setHtmlBody($body)
            ->send();

        return $this->redirect(["notif-download"]);
    }
    public function actionNotifDownload(){
        return $this->render('notif-download');
    }
    public function actionDownloadSuccess()
    {
        /** @var SettingKatalog $download */
        $download = SettingKatalog::find()->orderBy("id DESC")->one();
        $file_download = $download->file_path;
        return $this->render('download-success', [
            "url" => Url::to(['/uploads/katalog/' . $file_download])
        ]);
    }

    public function actionDownloadKatalog()
    {
        /** @var SettingKatalog $download */
        $download = SettingKatalog::find()->orderBy("id DESC")->one();
        $file_download = $download->file_path;
        return $this->redirect(['/uploads/katalog/' . $file_download]);
    }
}
