<?php

$params = require __DIR__ . '/../../common/config/params.php';
$db = require __DIR__ . '/../../common/config/db.php';

$config = [
    'id' => 'basic',
    'controllerMap' => [ //controller map yaitu mengarahkan controller ke URL yang Anda tentukan sendiri
        // declares "account" controller using a class name
        'demo' => 'app\controllers\IndexController',
        //index.php?r=demo
    ],
    'defaultRoute' => 'index', //defaultRoute
    /*'components' => [ mengaktifkan pretty url agar URL diubah menjadi bentuk segmen dibandingkan query string. Anda dapat menambahkan urlManager di dalam parameter components di $config
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => true,
            'enableStrictParsing' => false,
            'rules' => [],
        ],
    ],*/
    //'language' => 'id',
    //'sourceLanguage' => 'en',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm' => '@vendor/npm-asset',
    ],
    'components' => [
        'request' => [
            // !!! insert a secret key in the following (if it is empty) - this is required by cookie validation
            'cookieValidationKey' => 'klikklik',
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'user' => [
            'identityClass' => 'app\models\User',
            'enableAutoLogin' => true,
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
              'useFileTransport' => false,
              'transport' => [
//                  'class' => 'Swift_SmtpTransport',
//                  'host' => 'smtp.gmail.com',
//                  'username' => 'platinum.website.mail@gmail.com',
//                  'password' => 'Klikklik69',
//                  'port' => '587',
//                  'encryption' => 'tls',

                  'class' => 'Swift_SmtpTransport',
                  'host' => 'mail.platinumceramics.com',
                  'username' => 'test.dua@platinumceramics.com',
                  'password' => 'Test2pwd7235*',
                  'port' => '25',
                  'encryption' => 'tls',
              ],
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'db' => $db,
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
                'news/index' => 'news/index',
                'news/media-detail' => 'news/media-detail',
                'news/news-events-detail' => 'news/news-events-detail',
                'our-company/<slug>' => 'our-company/view',
                'news/<slug>' => 'news/view',
                'page/<slug>' => 'page/view',
                'product/<id>/<brand>/<color>' => 'product/detail',
                'inspiration/<id>/<title>' => 'inspiration/detail',
                'thumb/<folder>/<file>' => 'thumb/index'
            ],
        ],
        'i18n' => [
            'translations' => [
                '*' => [
                    'class' => 'yii\i18n\PhpMessageSource',
                    'basePath' => '@app/config/messages', // if advanced application, set @frontend/messages
                    //'sourceLanguage' => 'en',
                    'fileMap' => [
                        'app' => 'app.php',
                    ],
                ],
            ],
        ],
        'socialShare' => [
            'class' => \ymaker\social\share\configurators\Configurator::class,
            'socialNetworks' => [
                'vkontakte' => [
                    'class' => \ymaker\social\share\drivers\Vkontakte::class,
                ],
                'facebook' => [
                    'class' => \ymaker\social\share\drivers\Facebook::class,
                ],
                'odnoklasniki' => [
                    'class' => \ymaker\social\share\drivers\Odnoklassniki::class,
                ],
            ],
        ],
        'reCaptcha' => [
            'class' => 'himiklab\yii2\recaptcha\ReCaptchaConfig',
            'siteKeyV2' => '6Lcjj6AUAAAAAK4JEAnz16LevhJdxzbGIrR7dRkE',
            'secretV2' => '6Lcjj6AUAAAAAGHB7bGDfVZGA4S3m-HrqO-jl76K',
            'siteKeyV3' => 'your siteKey v3',
            'secretV3' => 'your secret key v3',
        ],
    ],
    'modules' => [
        'social' => [
            // the module class
            'class' => 'kartik\social\Module',
     
            // the global settings for the Disqus widget
            'disqus' => [
                'settings' => ['shortname' => 'DISQUS_SHORTNAME'] // default settings
            ],
     
            // the global settings for the Facebook plugins widget
            'facebook' => [
                'appId' => 'FACEBOOK_APP_ID',
                'secret' => 'FACEBOOK_APP_SECRET',
            ],
     
            // the global settings for the Google+ Plugins widget
            'google' => [
                'clientId' => 'GOOGLE_API_CLIENT_ID',
                'pageId' => 'GOOGLE_PLUS_PAGE_ID',
                'profileId' => 'GOOGLE_PLUS_PROFILE_ID',
            ],
     
            // the global settings for the Google Analytics plugin widget
            'googleAnalytics' => [
                'id' => 'TRACKING_ID',
                'domain' => 'TRACKING_DOMAIN',
            ],
     
            // the global settings for the Twitter plugin widget
            'twitter' => [
                'screenName' => 'TWITTER_SCREEN_NAME'
            ],
     
            // the global settings for the GitHub plugin widget
            'github' => [
                'settings' => ['user' => 'GITHUB_USER', 'repo' => 'GITHUB_REPO']
            ],
        ],
        // your other modules
    ],
    'params' => $params,
];

if (YII_ENV_DEV) {
    // configuration adjustments for 'dev' environment
    //$config['bootstrap'][] = 'debug';
    $config['modules']['debug'] = [
        'class' => 'yii\debug\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];

    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];
}

return $config;
