<?php

use app\components\Tanggal;
use app\models\Career;
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */


$page = @$_GET['page'];
$name = @$_GET['name'];
$career = @$_GET['career'];

/** @var Career $job */
$job = Career::find()->where(["id" => $career])->one();
$title = $job->getJobTitle();
$deskrip = $job->getKonten();
$urlapply = $job->apply_url;

$this->title = $title;
?>
<style>
    .box-left-career {
        width: 100%;
        background-color: #333;
        color: #fff;
        margin-top: 20px;
        padding: 10px 20px;
    }

    .box-left-career a {
        color: #fff;
    }

    .box-sub-left {
        width: 100%;
        background-color: #333;
        margin: 5px 10px 5px 10px;
    }

    .square {
        width: 100px;
        height: 100px;
        border-radius: 5px;
        background-color: #fff;
        float: left;
        margin-right: 5px;
    }

    .p-left {
        font-size: 12px;
        margin: 0px 0px 1px 10px;
    }

    .p-left-c {
    }

    .img-fluid:hover {
        cursor: zoom-in;
    }

    .hov-cus {
        cursor: zoom-in;
    }

    .hov-cus:hover {
        cursor: zoom-in;
    }

    .btns2 {
        display: none;
    }

    @media only screen
    and (max-width: 750px) {
        .btns1 {
            display: none;
        }

        .btns2 {
            display: block;
        }
    }
</style>
<style>
    .twitter-share-button {
        width: 500px;

    }

    .widget.btn {
        position: relative;
        height: 15px;
        box-sizing: border-box;
        padding: 1px 8px 1px 6px;
        background-color: #1b95e0;
        color: #fff;
        border-radius: 3px;
        font-weight: 500;
        cursor: pointer;
    }

    .fb-share-button {
        background-color: #ff0000;
    }
</style>

<?= $this->render('@app/views/career/header'); ?>
<div class="container">
    <div class="row">
        <div class="col-sm-12 col-md-8" style="margin-top: 20px; margin-bottom: 20px;">
            <div class='row'>
                <div class='col-10 col-md-4' style="margin-top: 15px;">
                    <b style='font-size: 20px;'><?= $title ?></b>
                </div>
                <div class='col-2 col-md-8' style="text-align: right;margin-top: 8px;">
                    <?= \app\components\ShareButton::widget([
                        "position" => "left",
                        "text" => $this->title,
                        "url" => Url::current([], true)
                    ]) ?>
                </div>
                <div class='col-12'>
                    <hr>
                    <?= $deskrip; ?>
                </div>
            </div>
            <br/><br/>
            <a href="<?= Url::to(["/career/apply", "id" => $job->id]) ?>"
               target="blank"><?= Html::submitButton("<i class='fa fa-paper-plane'></i> " . app\models\Language::t("app", 'Apply Now'), ['class' => 'btn btn-lg btn-secondary']); ?></a>
        </div>
        <div class="col-sm-12 col-sm-6 col-md-4">
            <div class="box-left-career">
                <h4 style="margin-bottom: 20px"><?= app\models\Language::t("app", "Other Jobs") ?></h4>

                <?php
                $query = Career::find();
                $listJob = $query->orderBy("id DESC")->limit(4)->all();

                foreach ($listJob as $job) {
                    ?>
                    <a href="<?= Url::to(["detail", "career" => $job->id]) ?>" class="color-a2">
                        <div class="media" style="margin-bottom: 10px">
                            <div class="media-body">
                                <div class="row">
                                    <div class="col-6">
                                        <h6 class="mt-0"><?= $job->getJobTitle() ?></h6>
                                    </div>
                                    <div class="col-6">
                                        <?= Tanggal::toReadableDate($job->created_at, false, true); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                    <?php
                }
                ?>
            </div>

            <br><br>
        </div>
    </div>
</div>
<script>
    // $(document).click(function(){
    //   $("#black-box-1").hide();
    //   $("#black-box-2").hide();
    // });
</script>